<?php
/**
 * The Template for displaying all single lots.
 *
 * Override this template by copying it to yourtheme/uco-auctions/single-lot.php
 *
 */

use uco_bidspirit_auction_integration\inc\abs\ImageModel;
use uco_bidspirit_auction_integration\inc\controllers\Settings;
use uco_bidspirit_auction_integration\inc\helpers\LotHelper;
use uco_bidspirit_auction_integration\inc\helpers\SettingsHelper;
use uco_bidspirit_auction_integration\inc\helpers\View;
use uco_bidspirit_auction_integration\inc\model\Auction;
use uco_bidspirit_auction_integration\inc\model\LotImage;

if (!defined('ABSPATH')) {
    exit;
}

get_header(); ?>
<?php  if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
    <?php
    /** @var WP_Post $post */
    /** @var WP_Term $auction */
    $auction = get_the_terms($post->ID, 'auction_number');

    if (!empty($auction)) {
        $auction = apply_filters('uco_prepare_auction_object', $auction[0]);
    }

    if (empty($auction)) {
        break;
    }

    $isAuctionShop = Auction::isAuctionShop($auction->term_id);
    $auctionId = SettingsHelper::getTermOption($auction->term_id, 'auction_id');
    $auctionTitle = apply_filters('uco_auction_name_build', $auction->name, $auction);
    $auctionDays = SettingsHelper::getTermOption($auction->term_id, 'auction_days');
    $auctionCommission = SettingsHelper::getTermOption($auction->term_id, 'auction_commission');
    $timeZoneName = SettingsHelper::getOption(Settings::OPTIONS_TIMEZONES, "");

    $displayStartPriceInCatalog = SettingsHelper::getTermOption($auction->term_id, 'auction_displayStartPriceInCatalog');
    $displayVatField = SettingsHelper::getOption('display_vat_field', 'on');

    $galleryTemplateType = SettingsHelper::getOption(Settings::LOT_SLIDER_TEMPLATE, 'slider');

    $onlyForUserAuth = SettingsHelper::isChecked(Settings::ONLY_FOR_USER_AUTH, false);

    $cdnUse = SettingsHelper::getOption('cdn_images', 'on');
    $imageList = '';
    $isCloned = '0';
    $templateImageList = 'false';

    $lotHelper = new LotHelper($post->ID);
    $cdnUseCondition = apply_filters('uco_cdn_use_conditions', ($cdnUse == 'on'), $cdnUse, $lotHelper);
    if ($cdnUseCondition) {
        $lotImages = new LotImage($post->ID);
        $images = $lotImages->getImageList();
        if (!empty($images[0])) {
            $featureImage = $images[0][ImageModel::LABEL_ORIGINAL];
            $featureImageThumb = $images[0][ImageModel::LABEL_CUSTOM];
        } else {
            $featureImage = LotHelper::getPlaceholderImage();
            $featureImageThumb = $featureImage;
        }

        $imageList = $lotImages->getLot()->getImagesListStr();
        $isCloned = $lotImages->getLot()->isCloned();
        $templateImageList = $lotImages->prepareUrlToTemplate();
    } else {
        $featureImage = get_the_post_thumbnail_url($post->ID, 'full');
        $featureImageId = get_post_thumbnail_id($post->ID);
        $featureImageThumb = get_the_post_thumbnail_url($post->ID, 'lot-slide');

        $images = get_attached_media('image');
        $images = array_values($images);
    }
    if (!empty($images[0])) {
        unset($images[0]);
    }
    $lotIndex = $lotHelper->getOptionValue('lot_itemIndex', 0);

    $auctionDay = Auction::getAuctionDayByItemID($lotIndex, $auctionDays);

    if (!empty($auctionDay->unknownExactDate)) {
        $dateTime = $auctionDay->date;
    } else {
        $dateTime = $auctionDay->date . 'T' . $auctionDay->time;
    }
    $nowDate = SettingsHelper::getDateTime();
    $timeToStart = (strtotime($dateTime) - strtotime($nowDate)) / 3600;
    $showcaseAutoClose = SettingsHelper::getOption('showcase_auto_close', 0);
    $isShowcaseEnable = SettingsHelper::getOption('showcase_enable', false, 'file');

    if ($isShowcaseEnable) {
        $showcaseEnable = (int)$timeToStart >= (int)$showcaseAutoClose;
    } else {
        $showcaseEnable = false;
    }

    try {
        $newDateTime = new DateTime($dateTime);
    } catch (Exception $e) {
        $newDateTime = new DateTime();
    }
    $dateTime = SettingsHelper::dateTimeFormat($dateTime);
    $customDateFormat = SettingsHelper::getOption('custom_format_display_time', '');
    $timeZoneLabel = SettingsHelper::getOption('time_zone_label', '');

    if ($timeZoneLabel != '') {
        $timeZoneLabel = "(" . $timeZoneLabel . ")";
    }

    $hiddenPrice = LotHelper::isHiddenLots($auctionDay);

    $part = false;
    if (isset($auctionDay->index) && is_array($auctionDays) && count($auctionDays) > 1) {
        $part = $auctionDay->index;
    }
    (strpos($_SERVER['REQUEST_URI'], '?') !== false) ? $delimiter = '&' : $delimiter = '?';

    $auctionListKey = 'auction_list';
    $pageAuctionListKey = SettingsHelper::getOption($auctionListKey, 0);
    $bgImage = get_the_post_thumbnail_url($pageAuctionListKey, 'full');
    $fullPriceVat = $lotHelper->getOptionValue('lot_fullPriceVat', '0');
    $video = $lotHelper->getOptionValue('lot_videoUrl', 0);
    $isRemovedItem = $lotHelper->getOptionValue('removedFromAuction', 0);
    ?>
    <div class="bp-container-fluid">
<?php if (!empty($bgImage)) { ?>
    <div class="bp-header bp-row bp-single-page" style="background-image: url('<?= $bgImage ?>')">
        <?php } else { ?>
        <div class="bp-header bp-row bp-single-page">
            <?php } ?>
            <div class="bp-header__overlay"></div>
            <div class="bp-header__content">
                <p class="title"><?= $auctionTitle ?></p>

				<?php if (!$isAuctionShop): ?>
				<p id="dateTimeField" class="bp-header__time"
                   data-custom-format="<?= $customDateFormat ?>"
                   data-custom-format-time="<?= date_i18n($customDateFormat, $newDateTime->getTimestamp()) . " " . $timeZoneLabel ?>"
                   data-time="<?= $dateTime ?>"
                   data-now-time="<?= $nowDate ?>"
                   data-time-to-start="<?= $timeToStart ?>"
                   data-showcase-enable="<?= $showcaseEnable ?>"
                   data-unknown-exact-date="<?= $auctionDay->unknownExactDate ?>"
                   data-time-zone="<?= $timeZoneName ?>"
                   data-is-dst="<?= $isDST ?? 0 ?>"
                   data-unknown-date="<?= date_i18n("F Y", strtotime($dateTime)) ?>">
                </p>
                <?php endif;?>

				<div id="userFront" class="bp-header__btn-group bp-d-flex bp-sm-f-wrap bp-sm-f-center">
                    <?php do_action('bp_user_front_single') ?>
                </div>
            </div>
        </div>
    </div>
    <div id="bp-notice-block" class="bp-main-container"></div>
    <?php do_action('bp_notice_action') ?>
    <?php do_action('bp_before_content_lot') ?>
    <div id="single-lot" data-hidden-price="<?= $hiddenPrice ?>" data-lot-index="<?= $lotIndex ?>"
         data-auction-index="<?= $auctionId ?>"
         data-auction-id="<?= $auctionId ?>"
         data-full-price-vat="<?= $fullPriceVat ?>"
         data-auction-commission="<?= $auctionCommission ?>"
         class="bp-lot bp-container bp-container_min"
    >
        <div class="bp-content bp-single-lot bp-justify-between bp-row">
            <?php do_action('bp_before_inner_content_lot') ?>
            <div class="bp-col">
                <div class="bp-single-lot__head bp-d-flex bp-f-between bp-lg-f-wrap">
                    <p class="bp-title"><?= LotHelper::printTranslateLot($lotIndex) ?>:</p>
                    <div class="bp-tools">
                        <?php
                        $prevLot = $lotHelper->da_the_adjacent_lot($lotIndex, $auction->term_id, 'prev');
                        $nextLot = $lotHelper->da_the_adjacent_lot($lotIndex, $auction->term_id, 'next');
                        $prevUrl = $prevLot ? get_permalink($prevLot->ID) : '#';
                        $nextUrl = $nextLot ? get_permalink($nextLot->ID) : '#';
                        ?>
                        <a href="<?= $prevUrl ?>" class="bp-tools__prev bp-tools__item<?= !$prevLot ? ' disabled' : '' ?>"><?= __('prev', 'uco_api_bidspirit') ?></a>
                        <a data-id="<?= "#lot-" . $lotIndex ?>"
                            href="<?= LotHelper::getAuctionLink($auction->term_id, $part) ?>"
                           class="goback bp-tools__all bp-tools__item"><?= __("Back to the catalog", "uco_api_bidspirit") ?></a>
                        <a href="<?= $nextUrl ?>" class="bp-tools__next bp-tools__item<?= !$nextLot ? ' disabled' : '' ?>"><?= __('next', 'uco_api_bidspirit') ?></a>
                    </div>
                </div>
                <div class="bp-single-lot__body bp-d-flex bp-f-between bp-lg-f-wrap">
                    <div class="bp-body__main bp-d-flex bp-f-wrap bp-lg-f-index-1">
                        <?php
                        $title = $lotHelper->getOptionValue('name', '');
                        $content = get_the_content();
                        $title = LotHelper::getLotTitle($title, $content);
                        ?>
                        <div class="bp-desc">
                            <h1><?= $title ?></h1>
                        </div>
                        <div id="soldBid" class="bp-control__notice_wrp hidden"></div>
                        <div class="lot-actions-wrp bp-control bp-control_nopadding">
                            <?php do_action('bp_before_bid_form_section', $post, $lotHelper) ?>
							<?php if (!$isAuctionShop) { ?>
						    <form id="bidFormSection" class="bp-from bp-control__inner bp-pb-15">
                                <span class="bp__wishlist"></span>
                                <div id="auctionStartTimer" class="bp-control__title"><?= __('The auction will start in <span class="outputDays">__</span> days and <span class="outputHours">__</span> hours', 'uco_api_bidspirit'); ?></div>
                                <?php if ($isRemovedItem != "1") { ?>
                                    <div id="auctionIsLive-section" class="bp-control__bid bp-form-group bp-form-group_select"></div>
                                <?php } ?>
                                <?php do_action('bs_bidFormSection_action', $lotIndex, $dateTime); ?>
                                <?php
                                $startPrice = $lotHelper->getOptionValue('lot_start_price', 0);
                                ?>
                                <div class="bp-control__desc">
                                    <?php if ($displayStartPriceInCatalog == '1' && $startPrice != 0) { ?>
                                        <p class="bp-control__price">
                                            <?= __('Start price', 'uco_api_bidspirit') ?>: <span id="startPriceSingleLot"><?=LotHelper::formattedPrice($startPrice) ?></span>
                                        </p>
                                    <?php } ?>
                                    <?php
                                    $estimatedPrice = $lotHelper->getOptionValue('lot_estimated_price', 0);
                                    if (!empty($estimatedPrice)) { ?>
                                    <p class="bp-control__estimate"><?= __('Estimated price', 'uco_api_bidspirit') ?>:
                                        <span><?= $estimatedPrice ?></span></p>
                                    <?php } ?>
                                    <?php if (!empty($auctionCommission)) { ?>
                                        <p class="bp-control__commission"><?= __('Auction house commission', 'uco_api_bidspirit') ?>: <span
                                                    id="auction-commission-field"></span></p>
                                    <?php } ?>
                                    <?php if ($displayVatField == 'on') { ?>
                                        <?php do_action('bp_vat_and_commission_field'); ?>
                                    <?php } ?>
                                </div>
                            </form>
					        <?php } ?>
                            <?php do_action('bp_after_bid_form_section') ?>
                            <div id="preSale-section" data-auction-commission="<?= $auctionCommission ?>"
                                 data-full-price-vat="<?= $fullPriceVat ?>"
                                 data-is-shop="<?= boolval($isAuctionShop) ?>"
                                 class="wrp-buyout-block bp-control__desc bp-control__inner bp-p-0"></div>
                        </div>
                        <?php if ($isRemovedItem != "1") { ?>
                            <div id="leadingBid" class="bp-control__notice_wrp bp-d-flex bp-f-start hidden"></div>
                        <?php } ?>
                        <div class="bp-body__main_content">
                            <?php do_action('bp_before_main_content') ?>
                            <?php $author = $lotHelper->getOptionValue('lot_author', "noname") ?>
                            <?php if ($author != "") { ?>
                                <p class="title <?= ($author == "noname") ? "hidden" : "" ?>"><?= $author ?></p>
                            <?php } else { ?>
                                <p class="title"><?= __("Description", "uco_api_bidspirit") ?></p>
                            <?php } ?>
                            <?php do_action('bp_after_title_main_content') ?>
                            <div class="body bp-mb-15">
                                <?php the_content(); ?>
                            </div>
                            <?php do_action('bp_after_main_content') ?>
                            <?php do_action('bp_after_main_content_ext', $post, $lotHelper) ?>
                        </div>
                        <?php do_action('bp_single_tool_lot') ?>
                    </div>
                    <?php
                    $galleryFields = compact('featureImage', 'featureImageThumb', 'images', 'cdnUse', 'imageList', 'isCloned', 'templateImageList', 'cdnUseCondition', 'video', 'onlyForUserAuth');
                    ?>
                    <?php if ($galleryTemplateType == "slider") { ?>
                        <?= View::render('templates.parts.gallery-lot', $galleryFields); ?>
                    <?php } elseif ($galleryTemplateType == "grid") { ?>
                        <?= View::render('templates.parts.gallery-lot-grid', $galleryFields); ?>
                    <?php } ?>
                </div>
            </div>
            <?php do_action('bp_after_inner_content_lot') ?>
        </div>
    </div>
    <?php do_action('bp_after_content_lot') ?>
    <div id="bsLoader" class="bs-loader"></div>
    <?php break; ?>
<?php endwhile; ?>
    <!-- post navigation -->
<?php else: ?>
    <!-- no posts found -->
<?php endif;  ?>

<?php get_footer(); ?>