# UCO Auctions Navigation Patch

## What This Plugin Does

This plugin fixes the prev/next lot navigation buttons in the UCO Auctions plugin. The buttons were pointing to the same lot instead of navigating to adjacent lots.

**✨ NEW:** The plugin now **automatically re-applies patches** when the UCO Auctions plugin is updated, so you don't have to worry about losing the fix!

## Installation & Usage

### For the Current Site (londoncamera.smoothbyteit.dev):
The patch is already applied. This plugin is here for reference and replication to other sites.

### For Other Sites:

1. **Copy this entire plugin folder** to the other site:
   ```
   /wp-content/plugins/uco-navigation-patch/
   ```

2. **Activate the plugin** in WordPress Admin:
   - Go to Plugins
   - Find "UCO Auctions Navigation Patch"
   - Click "Activate"

3. **The plugin will automatically**:
   - Create backups of original files
   - Copy patched files to the uco-auctions plugin

4. **Test the navigation**:
   - Visit any lot page
   - Click prev/next buttons
   - They should now navigate between lots correctly

## Deactivation

If you deactivate this plugin, it will automatically restore the original files from backup.

## Files Patched

1. `uco-auctions/inc/helpers/LotHelper.php` - Fixed term_id to term_taxonomy_id conversion
2. `uco-auctions/templates/single-lot.php` - Fixed navigation button URL generation
3. `uco-auctions/src/scss/_single.scss` - Added disabled button styling
4. `uco-auctions/assets/css/libs.css` - Added disabled button styling (compiled)
5. `uco-auctions/assets/css/libs.min.css` - Added disabled button styling (minified)

## Technical Details

### The Bug
The `da_the_adjacent_lot()` method was receiving `term_id` but the SQL query expected `term_taxonomy_id`. These are different values in WordPress taxonomy tables.

### The Fix
- Converts `term_id` to `term_taxonomy_id` before database query
- Properly extracts post ID from returned objects
- Adds null checks for first/last lots
- Adds visual styling for disabled buttons

## Backup Location

Original files are backed up to:
```
/wp-content/uco-auctions-backup/
```

## Version History

**1.1.0** - Auto-reapplication feature
- Automatically re-applies patches when uco-auctions is updated
- Admin notices for patch status
- Detection of patch state

**1.0.0** - Initial release
- Basic patch application on activation
- Backup and restore functionality

## Author
SmoothByte IT
