<?php
/**
 * X-XSS-Protection Header
 * Enables browser's built-in XSS filter (legacy browsers)
 *
 * @package SmoothByte_Security_Pro
 */

if (!defined('ABSPATH')) {
    exit;
}

require_once SBSEC_PLUGIN_DIR . 'includes/security-headers/class-base-header.php';

/**
 * X-XSS-Protection Header Implementation
 */
class SBSEC_XSS_Protection extends SBSEC_Base_Header {
    
    /**
     * Constructor
     */
    public function __construct($options) {
        parent::__construct($options);
        $this->header_name = 'X-XSS-Protection';
    }
    
    /**
     * Check if header is enabled
     */
    public function is_enabled() {
        return !empty($this->options['security_headers_xss']);
    }
    
    /**
     * Get header name
     */
    public function get_name() {
        return 'X-XSS-Protection';
    }
    
    /**
     * Get header description
     */
    public function get_description() {
        return 'Enables the browser\'s built-in Cross-Site Scripting (XSS) filter. Note: Modern browsers use Content Security Policy instead.';
    }
    
    /**
     * Get header value
     */
    protected function get_value() {
        $mode = isset($this->options['security_headers_xss_mode']) 
            ? $this->options['security_headers_xss_mode'] 
            : 'block';
        
        // Mode: block (recommended), sanitize, or off
        switch ($mode) {
            case 'block':
                return '1; mode=block';
            case 'sanitize':
                return '1';
            case 'off':
                return '0';
            default:
                return '1; mode=block';
        }
    }
    
    /**
     * Get available modes
     */
    public function get_modes() {
        return array(
            'block' => array(
                'label' => 'Block (Recommended)',
                'description' => 'Enable XSS filter and prevent rendering of the page if attack is detected.',
            ),
            'sanitize' => array(
                'label' => 'Sanitize',
                'description' => 'Enable XSS filter and sanitize the page (remove unsafe parts).',
            ),
            'off' => array(
                'label' => 'Disabled',
                'description' => 'Disable XSS filter.',
            ),
        );
    }
}
