<?php
/**
 * X-Frame-Options Header
 * Prevents clickjacking attacks by controlling if the site can be embedded in iframes
 *
 * @package SmoothByte_Security_Pro
 */

if (!defined('ABSPATH')) {
    exit;
}

require_once SBSEC_PLUGIN_DIR . 'includes/security-headers/class-base-header.php';

/**
 * X-Frame-Options Header Implementation
 */
class SBSEC_XFrame_Options extends SBSEC_Base_Header {
    
    /**
     * Constructor
     */
    public function __construct($options) {
        parent::__construct($options);
        $this->header_name = 'X-Frame-Options';
    }
    
    /**
     * Check if header is enabled
     */
    public function is_enabled() {
        return !empty($this->options['security_headers_xframe']);
    }
    
    /**
     * Get header name
     */
    public function get_name() {
        return 'X-Frame-Options';
    }
    
    /**
     * Get header description
     */
    public function get_description() {
        return 'Prevents clickjacking attacks by controlling whether your site can be embedded in iframes on other sites.';
    }
    
    /**
     * Get header value
     */
    protected function get_value() {
        $mode = isset($this->options['security_headers_xframe_mode']) 
            ? $this->options['security_headers_xframe_mode'] 
            : 'SAMEORIGIN';
        
        // Valid values: DENY, SAMEORIGIN
        $valid_modes = array('DENY', 'SAMEORIGIN');
        
        if (!in_array(strtoupper($mode), $valid_modes)) {
            $mode = 'SAMEORIGIN';
        }
        
        return strtoupper($mode);
    }
    
    /**
     * Get available modes
     */
    public function get_modes() {
        return array(
            'DENY' => array(
                'label' => 'DENY',
                'description' => 'The page cannot be displayed in a frame, regardless of the site attempting to do so.',
            ),
            'SAMEORIGIN' => array(
                'label' => 'SAMEORIGIN',
                'description' => 'The page can only be displayed in a frame on the same origin as the page itself.',
            ),
        );
    }
}
