<?php
/**
 * X-Content-Type-Options Header
 * Prevents MIME-sniffing attacks
 *
 * @package SmoothByte_Security_Pro
 */

if (!defined('ABSPATH')) {
    exit;
}

require_once SBSEC_PLUGIN_DIR . 'includes/security-headers/class-base-header.php';

/**
 * X-Content-Type-Options Header Implementation
 */
class SBSEC_Content_Type_Options extends SBSEC_Base_Header {
    
    /**
     * Constructor
     */
    public function __construct($options) {
        parent::__construct($options);
        $this->header_name = 'X-Content-Type-Options';
    }
    
    /**
     * Check if header is enabled
     */
    public function is_enabled() {
        return !empty($this->options['security_headers_content_type']);
    }
    
    /**
     * Get header name
     */
    public function get_name() {
        return 'X-Content-Type-Options';
    }
    
    /**
     * Get header description
     */
    public function get_description() {
        return 'Prevents browsers from MIME-sniffing a response away from the declared content-type, reducing exposure to drive-by download attacks.';
    }
    
    /**
     * Get header value
     */
    protected function get_value() {
        // Only one valid value for this header
        return 'nosniff';
    }
}
