/* SmoothByte Security Pro Admin JavaScript */

jQuery(document).ready(function($) {
    // Test Connection
    $('#sbsec-test-connection').on('click', function() {
        var button = $(this);
        button.prop('disabled', true).text('Testing...');
        
        $.ajax({
            url: sbsecAdmin.ajaxurl,
            type: 'POST',
            data: {
                action: 'sbsec_test_connection',
                nonce: sbsecAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    showMessage('Connection successful! Server version: ' + response.data.version, 'success');
                } else {
                    showMessage('Connection failed: ' + response.data, 'error');
                }
                button.prop('disabled', false).text('Test Connection');
            },
            error: function() {
                showMessage('Connection failed', 'error');
                button.prop('disabled', false).text('Test Connection');
            }
        });
    });
    
    // Request Access
    $('#sbsec-request-access').on('click', function() {
        var button = $(this);
        var serverUrl = $('#sbsec-server-url').val();
        
        if (!serverUrl) {
            showMessage('Please enter a server URL', 'error');
            return;
        }
        
        if (!confirm('Register this site with the deployment server?\n\nYour site will receive an API key automatically.')) {
            return;
        }
        
        button.prop('disabled', true).html('<span class="dashicons dashicons-update dashicons-spin"></span> Requesting...');
        
        $.ajax({
            url: sbsecAdmin.ajaxurl,
            type: 'POST',
            data: {
                action: 'sbsec_request_access',
                nonce: sbsecAdmin.nonce,
                server_url: serverUrl
            },
            success: function(response) {
                if (response.success) {
                    showMessage(response.data.message, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    showMessage('Request failed: ' + response.data, 'error');
                    button.prop('disabled', false).text('Request Access');
                }
            },
            error: function() {
                showMessage('Request failed', 'error');
                button.prop('disabled', false).text('Request Access');
            }
        });
    });
    
    // Check for Updates Now
    $('#sbsec-check-updates').on('click', function() {
        var button = $(this);
        button.prop('disabled', true).text('Checking...');
        
        $.ajax({
            url: sbsecAdmin.ajaxurl,
            type: 'POST',
            data: {
                action: 'sbsec_check_updates',
                nonce: sbsecAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    showMessage(response.data.message, 'success');
                } else {
                    showMessage('Failed to check updates: ' + response.data, 'error');
                }
            },
            error: function() {
                showMessage('Failed to check updates', 'error');
            },
            complete: function() {
                button.prop('disabled', false).text('Check for Updates Now');
            }
        });
    });
    
    // Report Health to Server
    $('#sbsec-report-health').on('click', function() {
        var button = $(this);
        button.prop('disabled', true).text('Reporting...');
        
        $.ajax({
            url: sbsecAdmin.ajaxurl,
            type: 'POST',
            data: {
                action: 'sbsec_report_health',
                nonce: sbsecAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    showMessage(response.data.message, 'success');
                } else {
                    showMessage('Failed to report health: ' + response.data, 'error');
                }
            },
            error: function() {
                showMessage('Failed to report health', 'error');
            },
            complete: function() {
                button.prop('disabled', false).text('Report Health to Server');
            }
        });
    });
    
    // Install Update (from header banner or Updates tab)
    $('#sbsec-install-update, #sbsec-install-update-tab').on('click', function() {
        if (!confirm('Are you sure you want to install this update? The plugin will be updated and the page will reload.')) {
            return;
        }
        
        var button = $(this);
        var version = button.data('version');
        var originalText = button.html();
        
        button.prop('disabled', true).html('<span class="dashicons dashicons-update" style="animation: spin 1s linear infinite; margin-top: 3px;"></span> Installing...');
        
        $.ajax({
            url: sbsecAdmin.ajaxurl,
            type: 'POST',
            data: {
                action: 'sbsec_install_update',
                nonce: sbsecAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    button.html('<span class="dashicons dashicons-yes" style="margin-top: 3px;"></span> Update Installed!');
                    $('.sbsec-update-notice').css('background', '#d1fae5').css('border-left-color', '#10b981');
                    $('.sbsec-update-notice p').first().html('<span class="dashicons dashicons-yes" style="color: #10b981;"></span> Successfully updated to version ' + version + '! Reloading...');
                    
                    // Reload page after 2 seconds
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    button.prop('disabled', false).html(originalText);
                    alert('Update failed: ' + response.data);
                }
            },
            error: function() {
                button.prop('disabled', false).html(originalText);
                alert('Update failed. Please try again or update manually from the Plugins page.');
            }
        });
    });
    
    // Run Malware Scan
    $('#sbsec-run-scan').on('click', function() {
        var button = $(this);
        button.prop('disabled', true).text('Scanning...');
        
        $.ajax({
            url: sbsecAdmin.ajaxurl,
            type: 'POST',
            data: {
                action: 'sbsec_run_scan',
                nonce: sbsecAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    showMessage('Scan completed. Threats found: ' + response.data.threats.length, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    showMessage('Scan failed: ' + response.data, 'error');
                    button.prop('disabled', false).text('Run Scan Now');
                }
            },
            error: function() {
                showMessage('Scan failed', 'error');
                button.prop('disabled', false).text('Run Scan Now');
            }
        });
    });
    
    function showMessage(message, type) {
        var msgDiv = $('<div class="sbsec-update-status ' + type + '">' + message + '</div>');
        $('#sbsec-update-message').html(msgDiv);
    }
});
