# SmoothByte Security Pro - Installation & Setup Guide

## Overview

**SmoothByte Security Pro** is a comprehensive WordPress security plugin developed by SmoothByte IT as an original, copyright-compliant alternative to WP Defender Pro. It provides enterprise-grade security features with the same automatic update deployment system used by SEO-AEO-Optimizer.

## Key Features

### 🔥 Firewall Protection
- Real-time IP blocking
- Rate limiting (configurable requests per minute)
- Malicious request pattern detection
- SQL injection & XSS attack prevention
- Bad bot blocking
- Whitelist/blacklist management

### 🔐 Login Security
- Brute force protection
- Login attempt limiting (configurable max attempts)
- Lockout duration management
- Failed login logging
- Security headers on login page
- Custom login URL support (optional)

### 🔍 Malware Scanner
- Automated file scanning for malicious code
- Suspicious pattern detection
- WordPress core files scanning
- Plugin & theme scanning
- Uploads directory scanning
- Scheduled daily scans
- Email notifications for threats

### 🛡️ Security Hardening
- Disable file editing (DISALLOW_FILE_EDIT)
- Disable XML-RPC
- Remove WordPress version information
- Disable directory browsing
- Protect wp-config.php
- Disable user enumeration
- Security headers (X-Frame-Options, X-XSS-Protection, etc.)
- Force SSL for admin (optional)

### 📁 File Monitoring
- File integrity checking
- Baseline checksum creation
- Change detection
- Hourly monitoring
- Email alerts for file changes
- Track WordPress core, plugins, and themes

### 📊 Security Logs
- Comprehensive event logging
- 7-day/30-day statistics
- Event type categorization
- Severity levels (low, medium, high, critical)
- IP address tracking
- User activity logging
- Automated log cleanup (configurable retention)
- CSV export capability

### 🔄 Automatic Updates
- **Same deployment system as SEO-AEO-Optimizer**
- Integration with SmoothByte deployment server
- Automatic update checks (hourly)
- One-click registration (no master key required)
- Manual or automatic update installation
- Health status reporting
- REST API endpoint for remote deployment

## Installation

### Method 1: Via WordPress Admin (Recommended)
1. Upload `smoothbyte-security-pro` folder to `/wp-content/plugins/`
2. Go to **Plugins** in WordPress admin
3. Find "SmoothByte Security Pro"
4. Click **Activate**

### Method 2: Mass Deployment (All Sites)
```bash
# Copy plugin to all WordPress sites
for site in /www/wwwroot/*/wp-content/plugins; do
    cp -r /www/wwwroot/goldenauctions.smoothbyteit.dev/wp-content/plugins/smoothbyte-security-pro "$site/"
done

# Fix permissions
chown -R www:www /www/wwwroot/*/wp-content/plugins/smoothbyte-security-pro
```

## Configuration

### 1. Initial Setup
After activation, go to **Security** menu in WordPress admin.

### 2. Configure Update Server
1. Go to **Security → Updates** tab
2. Server URL: `https://wpdeploy.smoothbyteit.dev`
3. Click **Request Access** (automatic registration)
4. Enable/disable automatic update installation

### 3. Firewall Settings
- **Enable Firewall**: Turn on firewall protection
- **Rate Limit**: Set requests per minute (default: 60)
- **Block Malicious Requests**: Enable pattern-based blocking
- View and manage blocked IPs

### 4. Login Security
- **Max Attempts**: Number of failed logins allowed (default: 5)
- **Lockout Duration**: Minutes to lock out after failed attempts (default: 30)
- Optional: Configure custom login URL

### 5. Malware Scanner
- Click **Run Scan Now** for immediate scan
- Or wait for daily automated scan
- Review threat reports
- Configure email notifications

## Auto-Update System

### How It Works
1. **Deployment Server**: Connects to `https://wpdeploy.smoothbyteit.dev`
2. **Registration**: One-click automatic registration (no master key needed)
3. **Update Checks**: Hourly automatic checks for new versions
4. **Installation**: Auto-install or manual (based on settings)
5. **Health Reporting**: Reports site health twice daily

### REST API Endpoint
```
POST /wp-json/smoothbyte-security/v1/trigger-install
Headers: X-API-Key: {site_api_key}
```

### Manual Update Deployment
From deployment server:
```php
// Push update to specific site
POST https://yoursite.com/wp-json/smoothbyte-security/v1/trigger-install
{
  "plugin_slug": "smoothbyte-security-pro",
  "version": "1.0.1"
}
```

## Database Tables

The plugin creates 3 custom tables:

1. **`wp_sbsec_logs`**: Security event logs
2. **`wp_sbsec_blocked_ips`**: Blocked IP addresses
3. **`wp_sbsec_file_checksums`**: File integrity checksums

## Requirements

- **WordPress**: 5.8 or higher
- **PHP**: 7.4 or higher
- **MySQL**: 5.7 or higher
- **Server Access**: For file scanning and monitoring
- **Permissions**: Write access to wp-content for logs

## Comparison with WP Defender

| Feature | WP Defender Pro | SmoothByte Security Pro |
|---------|----------------|------------------------|
| Firewall | ✓ | ✓ |
| Login Security | ✓ | ✓ |
| Malware Scanner | ✓ | ✓ |
| File Monitoring | ✓ | ✓ |
| 2FA | ✓ | Planned (v1.1) |
| Security Reports | ✓ | ✓ |
| Auto-Updates | WPMU DEV Hub | SmoothByte Deployment Server |
| Branding | WPMU DEV | **SmoothByte IT** |
| Copyright | WPMU DEV | **Original Code - GPL v2** |

## Copyright & Licensing

**SmoothByte Security Pro** is an original work by SmoothByte IT, developed from scratch without copying any copyrighted code from WP Defender or other plugins. While inspired by common security best practices, all code is independently written and licensed under GPL v2 or later.

### License
- **License**: GPL v2 or later
- **Author**: SmoothByte IT
- **Website**: https://smoothbyteit.dev
- **Copyright**: © 2025 SmoothByte IT

## Support & Updates

- **Updates**: Automatic via SmoothByte deployment server
- **Support**: https://smoothbyteit.dev/support
- **Documentation**: Included in plugin files

## File Structure

```
smoothbyte-security-pro/
├── smoothbyte-security-pro.php (Main plugin file)
├── README.md
├── INSTALLATION-GUIDE.md
├── includes/
│   ├── class-firewall.php
│   ├── class-login-security.php
│   ├── class-malware-scanner.php
│   ├── class-security-hardening.php
│   ├── class-file-monitor.php
│   ├── class-security-logs.php
│   └── class-auto-updater.php (Same system as SEO-AEO-Optimizer)
├── admin/
│   └── class-admin-settings.php
└── assets/
    ├── css/
    │   └── admin.css
    └── js/
        └── admin.js
```

## Changelog

### Version 1.0.0 (2025-11-23)
- Initial release
- Firewall protection with IP blocking and rate limiting
- Login security with brute force protection
- Malware scanner with automated scheduling
- Security hardening features
- File integrity monitoring
- Comprehensive security logging
- Auto-update integration with SmoothByte deployment server
- Admin dashboard and settings interface

## Roadmap

### Version 1.1.0 (Planned)
- Two-Factor Authentication (2FA)
- CAPTCHA integration
- Geo-blocking by country
- Advanced security reports
- CSV/PDF export for logs
- Security score dashboard

### Version 1.2.0 (Planned)
- Vulnerability database integration
- Plugin/theme vulnerability scanning
- Security recommendations engine
- One-click security fixes
- White-label options

---

**Developed by SmoothByte IT** | https://smoothbyteit.dev
