# SmoothByte Security Pro - Changelog

## Version 1.5.4 - November 24, 2025

### 🎨 **UI Tweak**

#### **Smaller Date/Time Text** (Visual Adjustment)
- ✅ **Reduced:** Date/time text size by approximately 50%
- ✅ **Changed:** From `clamp(14px, 3.5vw, 18px)` to `clamp(10px, 2vw, 12px)`
- ✅ **Result:** More compact display in scanner stat cards
- ✅ **Benefit:** Better visual hierarchy - numbers stand out more

#### **New Sizes**
- **Date/Time Text:** 10-12px (previously 14-18px)
- **Large Numbers:** 32-48px (unchanged)
- **Font Weight:** 600 (slightly lighter than 700)

---

## Version 1.5.3 - November 24, 2025

### ✨ **Enhancement**

#### **Install Update from Updates Tab** (UX Improvement)
- ✅ **Added:** "Install Update Now" button directly on Updates tab
- ✅ **Shows:** Update available notice when new version is ready
- ✅ **Displays:** Current version vs. available version in table
- ✅ **One-Click:** Install updates without leaving the Updates page

#### **Update Available Notice**
- Yellow/orange warning box at top of Updates tab
- Shows available version number
- Large "Install Update Now" button
- Same functionality as header banner button

#### **Version Display**
- **Current Version:** Shows installed version
- **Available Version:** Shows new version with green arrow ⬆
- Color-coded: Orange for update notice, green for "update available"

#### **User Experience**
- Update from header banner OR Updates tab
- Both buttons use same install handler
- Confirmation dialog before installation
- Success message with auto-reload
- No need to navigate to WordPress Plugins page

---

## Version 1.5.2 - November 24, 2025

### 🎨 **UI Enhancement**

#### **Fluid Responsive Typography** (UX Improvement)
- ✅ **Added:** Dynamic text sizing using CSS `clamp()` function
- ✅ **Responsive:** Text scales smoothly based on viewport and container width
- ✅ **Smart:** Automatically adjusts between minimum and maximum sizes
- ✅ **Better:** Enhanced mobile/tablet layouts with breakpoints

#### **Typography Ranges**
- **Date/Time Text:** `clamp(12px, 3.5vw, 18px)` - scales 12px→18px
- **Large Numbers:** `clamp(32px, 5vw, 48px)` - scales 32px→48px
- **Mobile Numbers:** `clamp(28px, 7vw, 36px)` - optimized for small screens

#### **Responsive Breakpoints**
- **1200px:** Adjusts grid to 200px minimum columns
- **782px:** Two-column layout, reduced padding
- **480px:** Single column, mobile-optimized

#### **Benefits**
- Text always fits container
- No wrapping issues on any screen size
- Smooth scaling on window resize
- Better readability across all devices

---

## Version 1.5.1 - November 24, 2025

### 🎨 **UI Fix**

#### **Scanner Stats Card Text Display** (CSS Fix)
- ✅ **Fixed:** Date/time text wrapping and overlapping in "Last Scan" card
- ✅ **Improved:** Text sizing for date/time content (16px-18px instead of 42px)
- ✅ **Enhanced:** Card min-height and layout with flexbox
- ✅ **Added:** Better word wrapping and line height for text content
- ✅ **Updated:** Scanner cards to match modern gradient design

#### **What Changed**
- Date/time now displays at readable 18px font size
- Numbers still display large at 42px
- Cards have consistent min-height of 120px
- Better text wrapping prevents overlap
- Gradient animations on hover
- Modern shadows and borders

---

## Version 1.5.0 - November 24, 2025

### ✨ **New Feature**

#### **One-Click Update Installation** (Major Enhancement)
- ✅ **Added:** "Install Update Now" button on admin page when update is available
- ✅ **Added:** Prominent update notification banner at top of Security settings
- ✅ **Shows:** Current version vs. available version
- ✅ **One-click:** Install updates directly from Security page without going to WordPress Plugins page
- ✅ **Auto-reload:** Page reloads after successful update

#### **Update Notification Banner**
- Appears at top of all Security admin pages
- Shows update version and current version
- Yellow/orange warning style with info icon
- Install button with download icon
- Disappears after successful installation

#### **User Experience**
- **Before:** Navigate to Plugins → Updates → Select → Update
- **After:** Click "Install Update Now" button → Done! ✓
- Confirmation dialog before installation
- Loading state with spinning animation
- Success message with auto-reload
- Error handling with helpful messages

#### **Security**
- Requires `update_plugins` capability
- AJAX nonce verification
- Uses WordPress native upgrader
- Logs all update attempts

---

## Version 1.4.2 - November 24, 2025

### 🎨 **UI Improvement**

#### **Date/Time Formatting** (UX Enhancement)
- ✅ **Fixed:** Date/time now displays in user-friendly format
- ✅ **Changed:** Uses WordPress date/time format settings
- ✅ **Applied to:**
  - Last Scan date/time
  - Signature Updated date/time
  - Scan History table dates

#### **Before & After**
- **Before:** `2025-11-24 01:54:56` (database format)
- **After:** `November 24, 2025 at 1:54 am` (user-friendly format)

#### **Format Source**
- Uses site's configured date/time format from Settings → General
- Respects localization and timezone settings
- Automatically updates if site settings change

---

## Version 1.4.1 - November 24, 2025

### 🐛 **Bug Fix**

#### **Malware Scanner Not Scanning Files** (Critical Fix)
- ✅ **Fixed:** Scanner was scanning 0 files when triggered via "Run Full Scan" button
- ✅ **Root Cause:** Scan options (`scan_wp_core`, `scan_plugins`, `scan_themes`, `scan_uploads`) were not enabled
- ✅ **Solution:** Force-enable all scan options when scan is triggered via AJAX

#### **What Changed**
- `ajax_run_scan()` now ensures all scan options are enabled
- Scanner will now properly scan:
  - WordPress core files (wp-admin, wp-includes)
  - All installed plugins
  - All installed themes  
  - Uploads directory for malicious PHP files

#### **Expected Behavior**
- **Before:** 0 files scanned, 0.00s duration
- **After:** 10,000+ files scanned, 2-3s duration
- Should find threats if any exist on the site

---

## Version 1.4.0 - November 24, 2025

### 🎨 **Design Overhaul**

#### **Modern UI Redesign** (Visual Enhancement)
- ✅ **Complete CSS redesign** - Modern, professional, and fun to look at
- ✅ **Gradient backgrounds** - Beautiful color gradients throughout
- ✅ **Smooth animations** - Hover effects, transitions, and loading spinners
- ✅ **Better colors** - Professional color palette with CSS variables
- ✅ **Enhanced stat cards** - Elevated cards with shadows and hover effects
- ✅ **Modern buttons** - Gradient buttons with hover animations
- ✅ **Professional typography** - Better fonts, weights, and spacing
- ✅ **Responsive design** - Mobile-friendly layout
- ✅ **Status badges** - Color-coded badges for different states

#### **Visual Features**
- Color-coded stat boxes (blue, yellow/warning, green/success, red/danger)
- Animated hover effects on cards
- Gradient text for numbers
- Modern tab navigation
- Smooth transitions and animations
- Professional shadows and depth
- CSS variable system for easy theming

---

## Version 1.3.4 - November 24, 2025

### 🐛 **Debug & Fix**

#### **Signature Update Debugging** (Troubleshooting)
- ✅ **Added:** Debug logging to show request URL and API key prefix
- ✅ **Added:** Response status code and body length logging
- ✅ **Added:** Full response body in error logs (first 500 chars)
- ✅ **Fixed:** Undefined site_url warning in API endpoint

#### **What to Check**
1. Go to **Security → Scanner** tab
2. Click **"Update Signatures"**
3. Check **Security → Logs** tab
4. Look for entries showing:
   - Request URL and API key
   - Response HTTP status
   - Error details if any

---

## Version 1.3.3 - November 24, 2025

### 🐛 **Bug Fix**

#### **Signature Update Endpoint** (Critical Fix)
- ✅ **Fixed:** "Failed to update security signatures" error
- ✅ **Corrected:** Changed endpoint from `/api/get-malware-signatures` (POST) to `/api.php/malware-signatures` (GET)
- ✅ **Fixed:** Now uses correct HTTP method (GET instead of POST)
- ✅ **Improved:** Shows pattern count in success message

#### **What Changed**
- Endpoint: `/api.php/malware-signatures` (matches deployment server)
- Method: GET (not POST)
- Headers: X-API-Key for authentication
- Response: Stores in transient and shows pattern count

---

## Version 1.3.2 - November 24, 2025

### ✨ **Improvement**

#### **AJAX Handlers Added** (User Contribution)
- ✅ **Added:** Scanner AJAX handlers to admin settings
- ✅ **Added:** Signature update, scan, quarantine, restore, delete handlers
- ✅ **Improved:** Better integration with scanner functionality

---

## Version 1.3.1 - November 24, 2025

### 🐛 **Bug Fix**

#### **Signature Update Error Logging** (Bug Fix)
- ✅ **Improved:** Better error messages when signature update fails
- ✅ **Added:** Logs HTTP status codes and error details
- ✅ **Added:** Shows URL being accessed in error logs
- ✅ **Added:** Displays signature count on successful update
- ✅ **Fixed:** Better handling of API authentication errors

#### **Technical Details**
- Added `count_patterns()` helper method
- Logs detailed error information to Security Logs
- Shows HTTP status code in error messages
- Improved debugging for signature update failures
- Added sslverify => false for development environments

---

## Version 1.3.0 - November 24, 2025

### 🐛 **Bug Fix**

#### **Check for Updates Now Button** (Bug Fix)
- ✅ **Fixed:** "Check for Updates Now" button now works correctly
- ✅ **Changed:** Uses WordPress native `wp_update_plugins()` function
- ✅ **Improved:** Properly clears transient and triggers update check

#### **Technical Details**
- Changed from calling `check_for_updates()` directly to using WordPress API
- Calls `delete_site_transient('update_plugins')` to clear cache
- Calls `wp_update_plugins()` to trigger fresh check
- No longer passes incorrect parameters to filter method

---

## Version 1.2.9 - November 24, 2025

### 🐛 **Bug Fix**

#### **500 Error on Update Buttons** (Critical Fix)
- ✅ **Fixed:** 500 Internal Server Error when clicking "Check for Updates Now"
- ✅ **Fixed:** 500 Internal Server Error when clicking "Report Health to Server"
- ✅ **Added:** Singleton pattern to `SBSEC_Auto_Updater` class

#### **Technical Details**
- Added `get_instance()` static method to Auto Updater
- Stores instance in `$instance` property during construction
- AJAX handlers can now access the Auto Updater instance
- Matches singleton pattern used elsewhere in the codebase

---

## Version 1.2.8 - November 24, 2025

### ✨ **Improvement**

#### **Updates Tab Enhancements** (UX Improvement)
- ✅ **Added:** "Check for Updates Now" button (matches SEO plugin)
- ✅ **Added:** "Report Health to Server" button (matches SEO plugin)
- ✅ **Added:** Shows current version in Updates tab
- ✅ **Improved:** Complete feature parity with SEO & AEO Optimizer

#### **New Buttons**
1. **Check for Updates Now** - Manually trigger update check
2. **Report Health to Server** - Force immediate health report
3. **Test Connection** - Verify server connectivity (already existed)

#### **What Changed**
- Added `ajax_check_updates()` and `ajax_report_health()` methods
- Added JavaScript handlers for new buttons
- Shows current plugin version in settings table
- Better alignment with SEO plugin's Updates tab UI

---

## Version 1.2.7 - November 24, 2025

### 🐛 **Bug Fix**

#### **Signature Update After Registration** (Bug Fix)
- ✅ **Fixed:** Signature update now works immediately after site registration
- ✅ **Added:** Reload API key from database before checking
- ✅ **Improved:** No longer requires page reload after registration

#### **Technical Details**
- `ajax_update_signatures()` now reloads `server_url` and `api_key` from database
- Catches newly registered sites that got API key after scanner loaded
- Fixes issue where signature update failed until page was refreshed

---

## Version 1.2.6 - November 24, 2025

### ✨ **Improvement**

#### **Plugin Tracking** (Backend Integration)
- ✅ **Added:** Plugin now identifies itself to deployment server via `plugin_slug`
- ✅ **Enabled:** Deployment server can now track which plugins each site has
- ✅ **Improved:** Sites page shows connected plugins with version numbers
- ✅ **Multi-plugin support:** Sites with both SEO & Security plugins show both

#### **What Changed**
- Added `plugin_slug: 'smoothbyte-security-pro'` to health reports
- Deployment server stores plugin connections in JSON format
- Sites table now has "Plugins Connected" column
- Shows plugin badges: "SEO & AEO" and "Security Pro"

---

## Version 1.2.5 - November 24, 2025

### ✨ **Improvement**

#### **Better Error Messages** (UX Improvement)
- ✅ **Improved:** "Update Signatures" now shows helpful message when not connected
- ✅ **Added:** Clear instructions on how to connect to deployment server
- ✅ **Explained:** Why signature update fails and how to fix it

#### **What Changed**
- Added pre-flight check in `ajax_update_signatures()` for API key
- Displays step-by-step instructions when site isn't registered
- Explains that fallback signatures are being used in the meantime
- More user-friendly error handling

---

## Version 1.2.4 - November 24, 2025

### 🐛 **Bug Fix**

#### **jQuery Selector Error** (Bug Fix)
- ✅ **Fixed:** "Syntax error, unrecognized expression" jQuery error on Scanner tab
- ✅ **Fixed:** Tab switching now only handles hash-based tabs (#threats, #warnings, etc.)
- ✅ **Improved:** More specific selectors to avoid conflicts with page navigation tabs

#### **Technical Details**
- Tab switching now checks if href starts with '#' before processing
- Limited scope to `.sbsec-tabs` to avoid interfering with page-level tabs
- Prevents jQuery from trying to parse URL query strings as selectors

---

## Version 1.2.3 - November 24, 2025

### ✨ **Improvement**

#### **Automatic Registration** (UX Improvement)
- ✅ **Improved:** Now uses automatic registration like SEO & AEO Optimizer
- ✅ **Removed:** No longer requires manual Master API Key entry
- ✅ **Simplified:** One-click "Request Access" - completely automatic
- ✅ **FREE:** Automatic registration with no manual configuration

#### **What Changed**
- Switched from `/register-site` to `/request-access` endpoint
- Removed Master API Key input field from UI
- Added friendly instructions and improved button styling
- Server URL is now read-only (pre-configured)
- Stores site_id along with API key for future reference
- Better success/error messages

#### **User Experience**
**Before:** Enter server URL → Enter master key → Click button → Register  
**After:** Click button → Register automatically ✓

---

## Version 1.2.2 - November 24, 2025

### 🐛 **Bug Fix**

#### **Deployment Server Registration** (Bug Fix)
- ✅ **Fixed:** "Missing required fields" error when requesting access
- ✅ **Added:** Master API Key input field to Updates tab
- ✅ **Added:** Clear instructions on how to connect to deployment server
- ✅ **Improvement:** Now properly sends `master_key` required by server

#### **What Changed**
- Updated `ajax_request_access()` to require and send master API key
- Added password input field for Master API Key in admin UI
- Added helpful instructions box explaining connection process
- Updated JavaScript to collect and send master_key parameter

---

## Version 1.2.1 - November 24, 2025

### 🐛 **Bug Fixes**

#### **Admin AJAX Handlers** (Bug Fix)
- ✅ **Fixed:** Added missing AJAX handler for `sbsec_request_access`
- ✅ **Fixed:** Added missing AJAX handler for `sbsec_test_connection`
- ✅ **Fixed:** 400 Bad Request errors when clicking "Request Access" button
- ✅ **Improvement:** Updates tab now properly connects to deployment server

#### **Technical Details**
- Added `ajax_request_access()` method to handle server registration
- Added `ajax_test_connection()` method to validate server connectivity
- Both handlers include proper nonce verification and permission checks
- Automatically saves server URL and API key upon successful registration

---

## Version 1.2.0 - November 24, 2025

### 🚀 **Major Feature: Enhanced Malware Scanner with Deployment Server Integration**

#### **Core Scanner Enhancements**
- ✅ **100+ Malware Signatures** - Downloaded automatically from deployment server
  - Backdoor detection (C99, R57, WSO, B374K shells)
  - Malicious functions (eval, base64, gzinflate combinations)
  - WordPress-specific threats (hidden admin users, auto-login backdoors)
  - Remote access detection (file inclusion, suspicious CURL)
  - Database attack patterns (SQL injection attempts)
  - File operation threats (suspicious chmod, uploads)

- ✅ **Deployment Server Integration**
  - Automatic signature updates from central server
  - Scan results reported to deployment server
  - Centralized threat intelligence across all sites
  - Cached signatures (24-hour TTL) for performance

- ✅ **Intelligent Scanning**
  - Context-aware pattern matching
  - Line number reporting for threats
  - Severity classification (critical, high, medium, low)
  - File size and modification tracking
  - Real-time progress updates

#### **Quarantine System**
- ✅ **File Isolation** - Move infected files to secure quarantine
- ✅ **Restore Capability** - Restore false positives safely
- ✅ **Permanent Deletion** - Remove threats completely
- ✅ **Protected Storage** - Quarantine directory with .htaccess protection
- ✅ **Database Tracking** - Full audit trail of quarantined files

#### **Comprehensive Admin Interface**
- ✅ **Status Dashboard** - At-a-glance security overview
  - Last scan timestamp
  - Threats found count
  - Files scanned total
  - Quarantined files count

- ✅ **Scanner Controls**
  - One-click full scan
  - Manual signature updates
  - Signature version display
  - Last update timestamp

- ✅ **Real-Time Progress**
  - Live progress bar
  - Current file display
  - Files scanned counter
  - Threats detected counter

- ✅ **Tabbed Results View**
  - **Threats Tab**: Critical/high severity issues
  - **Warnings Tab**: Medium/low severity issues
  - **Quarantine Tab**: Isolated file management
  - **History Tab**: Past scan results

#### **Threat Management**
- ✅ **Per-Threat Actions**
  - Quarantine individual files
  - Delete threats permanently
  - View file details (path, size, line number)
  - See matched code snippets

- ✅ **Quarantine Management**
  - Restore files from quarantine
  - Delete quarantined files permanently
  - View quarantine reason
  - Track quarantine date/time

#### **Database Enhancements**
- ✅ **scan_results table** - Local scan history storage
- ✅ **quarantine table** - Track all quarantined files
- ✅ **Deployment server** - Central scan_reports table

#### **Technical Improvements**
- ✅ Signature caching for performance
- ✅ Progress polling every 2 seconds
- ✅ AJAX-based threat management
- ✅ Set time limit to prevent timeouts
- ✅ Graceful fallback if server unavailable
- ✅ Comprehensive error handling
- ✅ Security logging for all actions

---

## Version 1.1.0 - November 24, 2025

### 🎉 New Features

#### **Security Headers** (Major Feature)
- ✅ **X-Frame-Options** - Prevents clickjacking attacks by controlling iframe embedding
  - Modes: DENY, SAMEORIGIN
  - Protects against clickjacking and UI redressing attacks
  
- ✅ **X-XSS-Protection** - Browser-based XSS filter (legacy browser support)
  - Modes: Block, Sanitize, Disabled
  - Provides additional XSS protection layer
  
- ✅ **X-Content-Type-Options** - Prevents MIME-sniffing attacks
  - Forces "nosniff" to prevent drive-by downloads
  - Reduces attack surface from content-type confusion
  
- ✅ **Strict-Transport-Security (HSTS)** - Forces HTTPS connections
  - Configurable max-age (1 hour to 2 years)
  - Optional subdomain inclusion
  - Optional preload support
  - Requires valid SSL certificate
  
- ✅ **Referrer-Policy** - Controls referrer information leakage
  - 8 policy options available
  - Default: strict-origin-when-cross-origin (recommended)
  - Protects user privacy
  
- ✅ **Permissions-Policy** - Controls browser features
  - Manage: geolocation, microphone, camera, payment, USB, sensors
  - Default: All potentially dangerous features disabled
  - Reduces attack surface

### 🎨 Admin Interface
- ✅ New "Security Headers" tab in admin panel
- ✅ Individual toggle for each header type
- ✅ Visual status indicators
- ✅ "Test Headers" button to verify active headers
- ✅ Real-time header testing via AJAX
- ✅ SSL detection and warnings
- ✅ Helpful descriptions for each header

### 🔧 Technical Improvements
- ✅ Modular header class architecture
- ✅ Abstract base class for easy extension
- ✅ Individual header classes for maintainability
- ✅ WordPress `send_headers` action hook integration
- ✅ Header detection and conflict prevention
- ✅ Option storage in WordPress options table

### 📝 Configuration
- ✅ Master toggle for all headers
- ✅ Individual header enable/disable
- ✅ Mode selection for applicable headers
- ✅ Smart defaults (all enabled except HSTS)
- ✅ HSTS disabled by default (requires SSL)

---

## Version 1.0.0 - Initial Release

### Core Features
- ✅ IP-based firewall
- ✅ Login security (brute force protection)
- ✅ Basic malware scanner
- ✅ Security hardening tweaks
- ✅ File integrity monitor
- ✅ Security event logging
- ✅ Auto-updater integration
- ✅ Admin dashboard

---

## Upcoming Features

### Planned for Version 1.2.0
- 🔜 Mask Login (hide wp-login.php)
- 🔜 Custom login URL
- 🔜 404 redirects for login attempts

### Planned for Version 1.3.0
- 🔜 CAPTCHA Integration
  - reCAPTCHA v2/v3
  - hCaptcha support
  - Login/registration protection

### Planned for Version 1.4.0
- 🔜 Enhanced Malware Scanner
  - Quarantine system
  - Better pattern detection
  - Vulnerability database integration

---

## Installation Notes

### Version 1.1.0 Upgrade
- Automatic upgrade from 1.0.0
- New options added with safe defaults
- No database migration required
- New admin tab appears automatically

### Recommended Actions After Upgrade
1. Visit Security → Security Headers tab
2. Review default settings
3. If you have SSL, enable HSTS
4. Click "Test Headers" to verify
5. Adjust settings as needed

---

## Browser Compatibility

### Security Headers Support
- **X-Frame-Options**: All modern browsers + IE8+
- **X-XSS-Protection**: Legacy (deprecated in modern browsers)
- **X-Content-Type-Options**: All modern browsers
- **HSTS**: All modern browsers
- **Referrer-Policy**: All modern browsers
- **Permissions-Policy**: Modern browsers (Chrome 88+, Edge 88+)

---

## Performance Impact

### Security Headers
- **CPU**: Negligible (headers sent once per request)
- **Memory**: < 1KB per request
- **Load Time**: No measurable impact
- **Database**: Minimal (options cached by WordPress)

---

## Security Improvements

### Version 1.1.0 Security Score
With all headers enabled:
- ✅ **6/6 Security Headers Active**
- ✅ **A+ Rating on Security Headers Check**
- ✅ **Protection against**:
  - Clickjacking
  - XSS attacks (legacy browsers)
  - MIME-sniffing
  - HTTPS downgrade attacks
  - Referrer leakage
  - Unauthorized feature access

---

## Support & Documentation

- Plugin URI: https://smoothbyteit.dev
- Documentation: See INSTALLATION-GUIDE.md
- Feature Analysis: See DEFENDER-FEATURE-ANALYSIS.md
- Support: Contact SmoothByte IT

---

**Built with ❤️ by SmoothByte IT**
