<?php
/**
 * Robots.txt Optimizer Class
 * Handles robots.txt optimization for AI crawlers
 */

if (!defined('ABSPATH')) {
    exit;
}

class SEO_AEO_Robots_Optimizer {

    private $options;

    public function __construct($options) {
        $this->options = $options;
        $this->init_hooks();
    }

    private function init_hooks() {
        add_filter('robots_txt', array($this, 'optimize_robots_txt'), 10, 2);
    }

    /**
     * Optimize robots.txt for search engines and AI crawlers
     */
    public function optimize_robots_txt($output, $public) {
        if ($public == '0') {
            return $output;
        }

        $custom_rules = "# Optimized by SEO & AEO Optimizer\n\n";

        // AI Crawlers
        if ($this->options['allow_gptbot']) {
            $custom_rules .= "# ChatGPT\n";
            $custom_rules .= "User-agent: GPTBot\n";
            $custom_rules .= "Allow: /\n\n";
            
            $custom_rules .= "User-agent: ChatGPT-User\n";
            $custom_rules .= "Allow: /\n\n";
        }

        if ($this->options['allow_ccbot']) {
            $custom_rules .= "# Common Crawl (used by many AI services)\n";
            $custom_rules .= "User-agent: CCBot\n";
            $custom_rules .= "Allow: /\n\n";
        }

        if ($this->options['allow_anthropic']) {
            $custom_rules .= "# Claude AI\n";
            $custom_rules .= "User-agent: anthropic-ai\n";
            $custom_rules .= "Allow: /\n\n";
            
            $custom_rules .= "User-agent: Claude-Web\n";
            $custom_rules .= "Allow: /\n\n";
        }

        if ($this->options['allow_perplexity']) {
            $custom_rules .= "# Perplexity AI\n";
            $custom_rules .= "User-agent: PerplexityBot\n";
            $custom_rules .= "Allow: /\n\n";
        }

        if ($this->options['allow_youbot']) {
            $custom_rules .= "# You.com\n";
            $custom_rules .= "User-agent: YouBot\n";
            $custom_rules .= "Allow: /\n\n";
        }

        // Standard rules for all crawlers
        $custom_rules .= "# General rules\n";
        $custom_rules .= "User-agent: *\n";
        $custom_rules .= "Disallow: /wp-admin/\n";
        $custom_rules .= "Disallow: /wp-includes/\n";
        $custom_rules .= "Disallow: /wp-json/\n";
        $custom_rules .= "Disallow: /xmlrpc.php\n";
        $custom_rules .= "Disallow: /*?*\n";
        $custom_rules .= "Allow: /wp-admin/admin-ajax.php\n";
        $custom_rules .= "Allow: /wp-content/uploads/\n\n";

        // Sitemaps
        $custom_rules .= "# Sitemaps\n";
        $custom_rules .= "Sitemap: " . home_url('/sitemap.xml') . "\n";
        $custom_rules .= "Sitemap: " . home_url('/sitemap_index.xml') . "\n";
        $custom_rules .= "Sitemap: " . home_url('/wp-sitemap.xml') . "\n";

        return $custom_rules . "\n" . $output;
    }
}
