/**
 * SEO & AEO Optimizer Admin JavaScript
 */

jQuery(document).ready(function($) {
    
    // Enqueue WordPress media uploader
    if (typeof wp !== 'undefined' && wp.media) {
        wp.media.frames = {};
    }
    
    // Settings saved notice
    var urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('settings-updated') === 'true') {
        showNotice('Settings saved successfully!', 'success');
    }
    
    // Show notice function
    function showNotice(message, type) {
        var noticeClass = type === 'success' ? 'notice-success' : 'notice-error';
        var notice = $('<div class="notice ' + noticeClass + ' is-dismissible"><p>' + message + '</p></div>');
        $('.wrap h1').after(notice);
        
        setTimeout(function() {
            notice.fadeOut(function() {
                $(this).remove();
            });
        }, 3000);
    }
    
    // Tab navigation
    $('.nav-tab').on('click', function(e) {
        e.preventDefault();
        var tab = $(this).attr('href');
        window.location.href = tab;
    });
});
