<?php
/**
 * Updates Tab - Automatic Update Settings
 */

if (!defined('ABSPATH')) {
    exit;
}

$server_url = get_option('seo_aeo_update_server_url', 'https://wpdeploy.smoothbyteit.dev');
$api_key = get_option('seo_aeo_update_api_key', '');
$auto_update = get_option('seo_aeo_auto_update', true);
$is_configured = !empty($server_url) && !empty($api_key);
$is_registered = !empty($api_key); // Site is registered if it has an API key
?>

<div class="seo-aeo-updates-settings">
    <h2><?php _e('Automatic Updates Configuration', 'seo-aeo-optimizer'); ?></h2>
    
    <?php if ($is_registered): ?>
        <div class="notice notice-success inline" style="border-left-color: #48bb78;">
            <p>
                <strong><?php _e('✓ Site registered with update server', 'seo-aeo-optimizer'); ?></strong><br>
                <small><?php _e('Your site is connected and will receive automatic updates when available.', 'seo-aeo-optimizer'); ?></small>
            </p>
        </div>
    <?php elseif (!empty($server_url)): ?>
        <div class="notice notice-info inline">
            <p><strong><?php _e('ℹ Server configured, but site not registered', 'seo-aeo-optimizer'); ?></strong> - <?php _e('Register your site below using the Master API Key.', 'seo-aeo-optimizer'); ?></p>
        </div>
    <?php else: ?>
        <div class="notice notice-warning inline">
            <p><strong><?php _e('⚠ Update server not configured', 'seo-aeo-optimizer'); ?></strong> - <?php _e('Configure below to receive automatic updates from the deployment server.', 'seo-aeo-optimizer'); ?></p>
        </div>
    <?php endif; ?>
    
    <table class="form-table" role="presentation">
        <tr>
            <th scope="row">
                <label for="update_server_url"><?php _e('Deployment Server URL', 'seo-aeo-optimizer'); ?></label>
            </th>
            <td>
                <input type="url" 
                       id="update_server_url" 
                       name="update_server_url" 
                       value="<?php echo esc_attr($server_url); ?>" 
                       class="regular-text" 
                       placeholder="https://wpdeploy.yourdomain.com">
                <p class="description">
                    <?php _e('The URL of your WP Plugin Deployer server', 'seo-aeo-optimizer'); ?>
                </p>
            </td>
        </tr>
        
        <?php if (!$is_registered): ?>
        <tr>
            <th scope="row">
                <label><?php _e('Site Registration', 'seo-aeo-optimizer'); ?></label>
            </th>
            <td>
                <p class="description" style="margin-bottom: 15px;">
                    <?php _e('Click the button below to automatically request access to the deployment server. Your site will be registered and receive an API key instantly.', 'seo-aeo-optimizer'); ?>
                </p>
                <button type="button" id="request-access" class="button button-primary button-large">
                    <?php _e('🔑 Request Access (Free)', 'seo-aeo-optimizer'); ?>
                </button>
                <p class="description" style="margin-top: 10px; color: #48bb78;">
                    <?php _e('✓ No master key required • Instant approval • Free service', 'seo-aeo-optimizer'); ?>
                </p>
            </td>
        </tr>
        <?php else: ?>
        <tr>
            <th scope="row">
                <label for="update_api_key"><?php _e('Site API Key', 'seo-aeo-optimizer'); ?></label>
            </th>
            <td>
                <input type="text" 
                       id="update_api_key" 
                       name="update_api_key" 
                       value="<?php echo esc_attr($api_key); ?>" 
                       class="regular-text">
                <p class="description">
                    <?php _e('Your unique site API key (registered successfully)', 'seo-aeo-optimizer'); ?>
                </p>
                <button type="button" id="clear-registration" class="button" style="margin-top: 10px;">
                    <?php _e('Clear Registration & Re-register', 'seo-aeo-optimizer'); ?>
                </button>
            </td>
        </tr>
        <?php endif; ?>
        
        <tr>
            <th scope="row">
                <label for="auto_update"><?php _e('Automatic Installation', 'seo-aeo-optimizer'); ?></label>
            </th>
            <td>
                <label>
                    <input type="checkbox" 
                           id="auto_update" 
                           name="auto_update" 
                           value="1" 
                           <?php checked($auto_update, true); ?>>
                    <?php _e('Automatically install updates when deployed', 'seo-aeo-optimizer'); ?>
                </label>
                <p class="description">
                    <?php _e('If enabled, updates will be installed automatically. If disabled, you\'ll be notified but need to manually update.', 'seo-aeo-optimizer'); ?>
                </p>
            </td>
        </tr>
        
        <tr>
            <th scope="row"><?php _e('Current Version', 'seo-aeo-optimizer'); ?></th>
            <td>
                <strong><?php echo esc_html(SEO_AEO_VERSION); ?></strong>
            </td>
        </tr>
    </table>
    
    <p class="submit">
        <button type="button" id="save-update-settings" class="button button-primary">
            <?php _e('Save Update Settings', 'seo-aeo-optimizer'); ?>
        </button>
        <?php if ($is_registered): ?>
        <button type="button" id="test-connection" class="button button-secondary">
            <?php _e('Test Connection', 'seo-aeo-optimizer'); ?>
        </button>
        <button type="button" class="button button-secondary" id="check-updates-btn">
            <?php _e('Check for Updates Now', 'seo-aeo-optimizer'); ?>
        </button>
        <button type="button" class="button button-secondary" id="report-health-btn" style="margin-left: 10px;">
            <?php _e('Report Health to Server', 'seo-aeo-optimizer'); ?>
        </button>
        <?php endif; ?>
    </p>
    
    <div id="update-test-result" style="margin-top: 20px;"></div>
    
    <hr style="margin: 40px 0;">
    
    <h3><?php _e('How It Works', 'seo-aeo-optimizer'); ?></h3>
    <ol style="line-height: 2;">
        <li><strong><?php _e('Configure Server:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Enter your deployment server URL and API key above', 'seo-aeo-optimizer'); ?></li>
        <li><strong><?php _e('Automatic Checks:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Plugin checks for updates every 12 hours', 'seo-aeo-optimizer'); ?></li>
        <li><strong><?php _e('Notifications:', 'seo-aeo-optimizer'); ?></strong> <?php _e('You\'ll see update notifications in WordPress Updates screen', 'seo-aeo-optimizer'); ?></li>
        <li><strong><?php _e('Installation:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Updates install automatically or manually depending on your setting', 'seo-aeo-optimizer'); ?></li>
        <li><strong><?php _e('Health Monitoring:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Plugin reports status back to deployment server', 'seo-aeo-optimizer'); ?></li>
    </ol>
    
    <div class="notice notice-info inline" style="margin-top: 20px;">
        <p>
            <strong><?php _e('Need Help?', 'seo-aeo-optimizer'); ?></strong><br>
            <?php _e('Contact your deployment server administrator to get your API key.', 'seo-aeo-optimizer'); ?><br>
            <?php _e('Make sure the deployment server URL is accessible from this site.', 'seo-aeo-optimizer'); ?>
        </p>
    </div>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Clear registration
    $('#clear-registration').on('click', function() {
        if (!confirm('<?php _e('Are you sure you want to clear the registration? You will need to re-register this site.', 'seo-aeo-optimizer'); ?>')) {
            return;
        }
        
        var button = $(this);
        var originalText = button.text();
        button.prop('disabled', true).text('<?php _e('Clearing...', 'seo-aeo-optimizer'); ?>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'seo_aeo_clear_registration',
                nonce: '<?php echo wp_create_nonce('seo_aeo_admin'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    alert('<?php _e('Registration cleared! Page will reload.', 'seo-aeo-optimizer'); ?>');
                    location.reload();
                } else {
                    alert('<?php _e('Error clearing registration', 'seo-aeo-optimizer'); ?>');
                    button.prop('disabled', false).text(originalText);
                }
            },
            error: function() {
                alert('<?php _e('Error clearing registration', 'seo-aeo-optimizer'); ?>');
                button.prop('disabled', false).text(originalText);
            }
        });
    });
    
    $('#check-updates-btn').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).text('Checking...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'seo_aeo_check_updates_now',
                nonce: '<?php echo wp_create_nonce('seo_aeo_admin'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    alert('✓ Update check complete!\n\nMessage: ' + response.data.message);
                    location.reload();
                } else {
                    alert('Error: ' + (response.data || 'Unknown error'));
                }
            },
            error: function() {
                alert('Error checking for updates');
            },
            complete: function() {
                $btn.prop('disabled', false).text('Check for Updates Now');
            }
        });
    });
    
    $('#report-health-btn').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).text('Reporting...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'seo_aeo_report_health_now',
                nonce: '<?php echo wp_create_nonce('seo_aeo_admin'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    alert('✓ Health report sent successfully!\n\n' + 
                          'WP Version: ' + response.data.wp_version + '\n' +
                          'PHP Version: ' + response.data.php_version + '\n' +
                          'Plugin Version: ' + response.data.plugin_version);
                } else {
                    alert('Error: ' + (response.data || 'Unknown error'));
                }
            },
            error: function() {
                alert('Error sending health report');
            },
            complete: function() {
                $btn.prop('disabled', false).text('Report Health to Server');
            }
        });
    });
    
    // Request Access (Automatic Registration)
    $('#request-access').on('click', function() {
        var button = $(this);
        var originalText = button.html();
        var serverUrl = $('#update_server_url').val();
        
        if (!serverUrl) {
            alert('<?php _e('Please enter the Deployment Server URL first', 'seo-aeo-optimizer'); ?>');
            $('#update_server_url').focus();
            return;
        }
        
        button.prop('disabled', true).html('<?php _e('🔄 Requesting Access...', 'seo-aeo-optimizer'); ?>');
        
        $('#update-test-result').html(
            '<div class="notice notice-info inline"><p>' +
            '<strong><?php _e('Requesting Access...', 'seo-aeo-optimizer'); ?></strong><br>' +
            '<?php _e('Connecting to deployment server and requesting API key...', 'seo-aeo-optimizer'); ?>' +
            '</p></div>'
        );
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'seo_aeo_request_access',
                nonce: '<?php echo wp_create_nonce('seo_aeo_admin'); ?>',
                server_url: serverUrl
            },
            success: function(response) {
                if (response.success) {
                    $('#update-test-result').html(
                        '<div class="notice notice-success inline"><p>' +
                        '<strong>✓ <?php _e('Access Granted!', 'seo-aeo-optimizer'); ?></strong><br>' +
                        response.data.message + '<br>' +
                        '<small><?php _e('Your API Key:', 'seo-aeo-optimizer'); ?> ' + response.data.api_key.substring(0, 20) + '...</small>' +
                        '</p></div>'
                    );
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    $('#update-test-result').html(
                        '<div class="notice notice-error inline"><p>' +
                        '<strong>✗ <?php _e('Access Request Failed', 'seo-aeo-optimizer'); ?></strong><br>' +
                        response.data +
                        '</p></div>'
                    );
                    button.prop('disabled', false).html(originalText);
                }
            },
            error: function(xhr, status, error) {
                $('#update-test-result').html(
                    '<div class="notice notice-error inline"><p>' +
                    '<strong>✗ <?php _e('Connection Error', 'seo-aeo-optimizer'); ?></strong><br>' +
                    '<?php _e('Could not connect to deployment server. Please check the URL and try again.', 'seo-aeo-optimizer'); ?>' +
                    '</p></div>'
                );
                button.prop('disabled', false).html(originalText);
            }
        });
    });
    
    // Save update settings
    $('#save-update-settings').on('click', function() {
        var button = $(this);
        var originalText = button.text();
        var serverUrl = $('#update_server_url').val();
        var apiKey = $('#update_api_key').val() || '';
        
        if (!serverUrl) {
            alert('<?php _e('Please enter the Deployment Server URL', 'seo-aeo-optimizer'); ?>');
            return;
        }
        
        button.prop('disabled', true).text('<?php _e('Saving...', 'seo-aeo-optimizer'); ?>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'seo_aeo_save_update_settings',
                nonce: '<?php echo wp_create_nonce('seo_aeo_admin'); ?>',
                server_url: serverUrl,
                api_key: apiKey,
                auto_update: $('#auto_update').is(':checked') ? 1 : 0
            },
            success: function(response) {
                if (response.success) {
                    $('#update-test-result').html('<div class="notice notice-success inline"><p>' + response.data.message + '</p></div>');
                    $('#test-connection, #check-updates-now').prop('disabled', false);
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    $('#update-test-result').html('<div class="notice notice-error inline"><p>' + response.data + '</p></div>');
                }
            },
            error: function() {
                $('#update-test-result').html('<div class="notice notice-error inline"><p><?php _e('Error saving settings', 'seo-aeo-optimizer'); ?></p></div>');
            },
            complete: function() {
                button.prop('disabled', false).text(originalText);
            }
        });
    });
    
    // Test connection
    $('#test-connection').on('click', function() {
        var button = $(this);
        var originalText = button.text();
        button.prop('disabled', true).text('<?php _e('Testing...', 'seo-aeo-optimizer'); ?>');
        
        $('#update-test-result').html('<p><?php _e('Testing connection to deployment server...', 'seo-aeo-optimizer'); ?></p>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'seo_aeo_test_update_connection',
                nonce: '<?php echo wp_create_nonce('seo_aeo_admin'); ?>',
                server_url: $('#update_server_url').val(),
                api_key: $('#update_api_key').val()
            },
            success: function(response) {
                if (response.success) {
                    $('#update-test-result').html(
                        '<div class="notice notice-success inline"><p><strong>✓ ' + response.data.message + '</strong><br>' +
                        'Server Version: ' + response.data.version + '</p></div>'
                    );
                } else {
                    $('#update-test-result').html('<div class="notice notice-error inline"><p><strong>✗ Connection Failed</strong><br>' + response.data + '</p></div>');
                }
            },
            error: function() {
                $('#update-test-result').html('<div class="notice notice-error inline"><p><?php _e('Connection test failed', 'seo-aeo-optimizer'); ?></p></div>');
            },
            complete: function() {
                button.prop('disabled', false).text(originalText);
            }
        });
    });
    
    // Check for updates now
    $('#check-updates-now').on('click', function() {
        var button = $(this);
        var originalText = button.text();
        button.prop('disabled', true).text('<?php _e('Checking...', 'seo-aeo-optimizer'); ?>');
        
        $('#update-test-result').html('<p><?php _e('Checking for updates...', 'seo-aeo-optimizer'); ?></p>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'seo_aeo_check_updates_now',
                nonce: '<?php echo wp_create_nonce('seo_aeo_admin'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    if (response.data.has_update) {
                        $('#update-test-result').html(
                            '<div class="notice notice-warning inline"><p><strong>🔔 ' + response.data.message + '</strong><br>' +
                            '<?php _e('Go to Dashboard > Updates to install', 'seo-aeo-optimizer'); ?></p></div>'
                        );
                    } else {
                        $('#update-test-result').html(
                            '<div class="notice notice-success inline"><p><strong>✓ ' + response.data.message + '</strong></p></div>'
                        );
                    }
                } else {
                    $('#update-test-result').html('<div class="notice notice-error inline"><p>' + response.data + '</p></div>');
                }
            },
            error: function() {
                $('#update-test-result').html('<div class="notice notice-error inline"><p><?php _e('Update check failed', 'seo-aeo-optimizer'); ?></p></div>');
            },
            complete: function() {
                button.prop('disabled', false).text(originalText);
            }
        });
    });
});
</script>

<style>
.seo-aeo-updates-settings .notice.inline {
    margin: 20px 0;
}
.seo-aeo-updates-settings ol {
    margin-left: 20px;
}
</style>
