<?php if (!defined('ABSPATH')) exit; ?>

<h2><?php _e('Validation Tools', 'seo-aeo-optimizer'); ?></h2>

<div class="seo-aeo-tools-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin: 20px 0;">
    
    <div class="tool-card" style="background: #fff; border: 1px solid #ddd; padding: 20px; border-radius: 4px;">
        <h3><?php _e('Google Rich Results Test', 'seo-aeo-optimizer'); ?></h3>
        <p><?php _e('Test your pages for eligible rich result types.', 'seo-aeo-optimizer'); ?></p>
        <a href="https://search.google.com/test/rich-results?url=<?php echo urlencode(home_url('/')); ?>" target="_blank" class="button button-primary">
            <?php _e('Test Homepage', 'seo-aeo-optimizer'); ?>
        </a>
        <a href="https://search.google.com/test/rich-results" target="_blank" class="button">
            <?php _e('Test Any URL', 'seo-aeo-optimizer'); ?>
        </a>
    </div>

    <div class="tool-card" style="background: #fff; border: 1px solid #ddd; padding: 20px; border-radius: 4px;">
        <h3><?php _e('Schema.org Validator', 'seo-aeo-optimizer'); ?></h3>
        <p><?php _e('Validate your structured data markup.', 'seo-aeo-optimizer'); ?></p>
        <a href="https://validator.schema.org/#url=<?php echo urlencode(home_url('/')); ?>" target="_blank" class="button button-primary">
            <?php _e('Validate Homepage', 'seo-aeo-optimizer'); ?>
        </a>
        <a href="https://validator.schema.org/" target="_blank" class="button">
            <?php _e('Validate Any URL', 'seo-aeo-optimizer'); ?>
        </a>
    </div>

    <div class="tool-card" style="background: #fff; border: 1px solid #ddd; padding: 20px; border-radius: 4px;">
        <h3><?php _e('Facebook Sharing Debugger', 'seo-aeo-optimizer'); ?></h3>
        <p><?php _e('Test Open Graph tags and social sharing.', 'seo-aeo-optimizer'); ?></p>
        <a href="https://developers.facebook.com/tools/debug/?q=<?php echo urlencode(home_url('/')); ?>" target="_blank" class="button button-primary">
            <?php _e('Debug Homepage', 'seo-aeo-optimizer'); ?>
        </a>
        <a href="https://developers.facebook.com/tools/debug/" target="_blank" class="button">
            <?php _e('Debug Any URL', 'seo-aeo-optimizer'); ?>
        </a>
    </div>

    <div class="tool-card" style="background: #fff; border: 1px solid #ddd; padding: 20px; border-radius: 4px;">
        <h3><?php _e('Twitter Card Validator', 'seo-aeo-optimizer'); ?></h3>
        <p><?php _e('Preview and validate Twitter Cards.', 'seo-aeo-optimizer'); ?></p>
        <a href="https://cards-dev.twitter.com/validator" target="_blank" class="button button-primary">
            <?php _e('Validate Cards', 'seo-aeo-optimizer'); ?>
        </a>
    </div>

    <div class="tool-card" style="background: #fff; border: 1px solid #ddd; padding: 20px; border-radius: 4px;">
        <h3><?php _e('LinkedIn Post Inspector', 'seo-aeo-optimizer'); ?></h3>
        <p><?php _e('Test how your content appears on LinkedIn.', 'seo-aeo-optimizer'); ?></p>
        <a href="https://www.linkedin.com/post-inspector/" target="_blank" class="button button-primary">
            <?php _e('Inspect Posts', 'seo-aeo-optimizer'); ?>
        </a>
    </div>

    <div class="tool-card" style="background: #fff; border: 1px solid #ddd; padding: 20px; border-radius: 4px;">
        <h3><?php _e('View Robots.txt', 'seo-aeo-optimizer'); ?></h3>
        <p><?php _e('Check your current robots.txt file.', 'seo-aeo-optimizer'); ?></p>
        <a href="<?php echo home_url('/robots.txt'); ?>" target="_blank" class="button button-primary">
            <?php _e('View Robots.txt', 'seo-aeo-optimizer'); ?>
        </a>
    </div>
</div>

<hr style="margin: 40px 0;">

<h2><?php _e('Export / Import Settings', 'seo-aeo-optimizer'); ?></h2>

<div class="seo-aeo-export-import" style="background: #fff; border: 1px solid #ddd; padding: 20px; border-radius: 4px; max-width: 800px;">
    
    <div class="export-section" style="margin-bottom: 30px;">
        <h3><?php _e('Export Settings', 'seo-aeo-optimizer'); ?></h3>
        <p><?php _e('Download your current plugin settings as a JSON file. Use this to backup or transfer settings to another site.', 'seo-aeo-optimizer'); ?></p>
        <button type="button" class="button button-primary" id="export-settings">
            <?php _e('Export Settings', 'seo-aeo-optimizer'); ?>
        </button>
    </div>

    <div class="import-section">
        <h3><?php _e('Import Settings', 'seo-aeo-optimizer'); ?></h3>
        <p><?php _e('Upload a previously exported settings file to restore configuration.', 'seo-aeo-optimizer'); ?></p>
        <input type="file" id="import-file" accept=".json" style="margin-bottom: 10px;" />
        <button type="button" class="button button-primary" id="import-settings">
            <?php _e('Import Settings', 'seo-aeo-optimizer'); ?>
        </button>
        <p class="description"><?php _e('⚠️ Warning: Importing will overwrite your current settings.', 'seo-aeo-optimizer'); ?></p>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Export settings
    $('#export-settings').on('click', function() {
        var settings = <?php echo json_encode(get_option('seo_aeo_options')); ?>;
        var dataStr = "data:text/json;charset=utf-8," + encodeURIComponent(JSON.stringify(settings, null, 2));
        var downloadAnchorNode = document.createElement('a');
        downloadAnchorNode.setAttribute("href", dataStr);
        downloadAnchorNode.setAttribute("download", "seo-aeo-settings-" + Date.now() + ".json");
        document.body.appendChild(downloadAnchorNode);
        downloadAnchorNode.click();
        downloadAnchorNode.remove();
        alert('<?php _e('Settings exported successfully!', 'seo-aeo-optimizer'); ?>');
    });
    
    // Import settings
    $('#import-settings').on('click', function() {
        var fileInput = document.getElementById('import-file');
        if (!fileInput.files.length) {
            alert('<?php _e('Please select a file first.', 'seo-aeo-optimizer'); ?>');
            return;
        }
        
        var file = fileInput.files[0];
        var reader = new FileReader();
        
        reader.onload = function(e) {
            try {
                var settings = JSON.parse(e.target.result);
                
                if (!confirm('<?php _e('Are you sure you want to import these settings? This will overwrite your current configuration.', 'seo-aeo-optimizer'); ?>')) {
                    return;
                }
                
                $.post(ajaxurl, {
                    action: 'seo_aeo_import_settings',
                    settings: JSON.stringify(settings),
                    nonce: '<?php echo wp_create_nonce('seo_aeo_import'); ?>'
                }, function(response) {
                    if (response.success) {
                        alert('<?php _e('Settings imported successfully! Page will reload.', 'seo-aeo-optimizer'); ?>');
                        location.reload();
                    } else {
                        alert('<?php _e('Error importing settings. Please check the file format.', 'seo-aeo-optimizer'); ?>');
                    }
                });
            } catch (error) {
                alert('<?php _e('Invalid JSON file. Please check the file format.', 'seo-aeo-optimizer'); ?>');
            }
        };
        
        reader.readAsText(file);
    });
});
</script>

<hr style="margin: 40px 0;">

<h2><?php _e('Auction Plugin Compatibility', 'seo-aeo-optimizer'); ?></h2>

<?php
if (class_exists('SEO_AEO_Auction_Compatibility')) {
    $compat_status = SEO_AEO_Auction_Compatibility::get_status();
    
    $mode_color = $compat_status['mode'] === 'direct' ? '#4caf50' : '#ff9800';
    $mode_text = $compat_status['mode'] === 'direct' ? 'Direct Integration (Full Features)' : 'Fallback Mode (Limited Features)';
    
    $last_check = get_option('seo_aeo_last_compat_check', 'Never');
    $next_check = wp_next_scheduled('seo_aeo_daily_compat_check');
    $next_check_text = $next_check ? date('Y-m-d H:i:s', $next_check) : 'Not scheduled';
    ?>
    
    <div class="seo-aeo-compat-status" style="background: #fff; border: 1px solid #ddd; padding: 20px; border-radius: 4px; max-width: 800px;">
        <table class="widefat">
            <tr>
                <th><?php _e('Status:', 'seo-aeo-optimizer'); ?></th>
                <td style="color: <?php echo $mode_color; ?>; font-weight: bold;">
                    <?php echo $mode_text; ?>
                </td>
            </tr>
            <tr>
                <th><?php _e('UCO Auctions Version:', 'seo-aeo-optimizer'); ?></th>
                <td><?php echo esc_html($compat_status['version']); ?></td>
            </tr>
            <tr>
                <th><?php _e('Last Check:', 'seo-aeo-optimizer'); ?></th>
                <td><?php echo esc_html($last_check); ?></td>
            </tr>
            <tr>
                <th><?php _e('Next Scheduled Check:', 'seo-aeo-optimizer'); ?></th>
                <td><?php echo esc_html($next_check_text); ?></td>
            </tr>
            <tr>
                <th><?php _e('Required Classes:', 'seo-aeo-optimizer'); ?></th>
                <td>
                    LotHelper: <?php echo $compat_status['classes_available']['LotHelper'] ? '✅ Available' : '❌ Missing'; ?><br>
                    SettingsHelper: <?php echo $compat_status['classes_available']['SettingsHelper'] ? '✅ Available' : '❌ Missing'; ?><br>
                    Auction: <?php echo $compat_status['classes_available']['Auction'] ? '✅ Available' : '❌ Missing'; ?>
                </td>
            </tr>
        </table>
        
        <?php if (!empty($compat_status['log'])): ?>
        <h4 style="margin-top: 20px;"><?php _e('Compatibility Log:', 'seo-aeo-optimizer'); ?></h4>
        <table class="widefat">
            <thead>
                <tr>
                    <th>Time</th>
                    <th>Message</th>
                    <th>Version</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach (array_reverse($compat_status['log']) as $entry): ?>
                <tr>
                    <td><?php echo esc_html($entry['time']); ?></td>
                    <td><?php echo esc_html($entry['message']); ?></td>
                    <td><?php echo esc_html($entry['version']); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php endif; ?>
    </div>
    
    <div class="seo-aeo-info-box" style="background: #e3f2fd; border-left: 4px solid #2196f3; padding: 15px; margin: 20px 0; max-width: 800px;">
        <h3 style="margin-top: 0;">ℹ️ <?php _e('About Compatibility Mode', 'seo-aeo-optimizer'); ?></h3>
        <p><strong><?php _e('Direct Mode:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Uses UCO plugin classes directly for full features (recommended)', 'seo-aeo-optimizer'); ?></p>
        <p><strong><?php _e('Fallback Mode:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Uses WordPress post meta when UCO classes change. SEO continues working but some advanced features may be limited.', 'seo-aeo-optimizer'); ?></p>
        <p><?php _e('If you see Fallback Mode after a UCO plugin update, your SEO is still working! Contact support if you need full feature restoration.', 'seo-aeo-optimizer'); ?></p>
    </div>
    
    <div class="seo-aeo-info-box" style="background: #e8f5e9; border-left: 4px solid #4caf50; padding: 15px; margin: 20px 0; max-width: 800px;">
        <h3 style="margin-top: 0;">🤖 <?php _e('Automatic Compatibility Checks', 'seo-aeo-optimizer'); ?></h3>
        <p><?php _e('Your plugin automatically checks compatibility in multiple ways:', 'seo-aeo-optimizer'); ?></p>
        <ul>
            <li><strong><?php _e('Daily WP-Cron:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Runs once per day automatically', 'seo-aeo-optimizer'); ?></li>
            <li><strong><?php _e('Plugin Updates:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Immediate check when UCO plugin updates', 'seo-aeo-optimizer'); ?></li>
            <li><strong><?php _e('Admin Visits:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Checks when you visit admin pages', 'seo-aeo-optimizer'); ?></li>
            <li><strong><?php _e('Activation Changes:', 'seo-aeo-optimizer'); ?></strong> <?php _e('Checks when UCO plugin is activated/deactivated', 'seo-aeo-optimizer'); ?></li>
        </ul>
        <p><?php _e('You don\'t need to do anything - the system monitors itself!', 'seo-aeo-optimizer'); ?></p>
    </div>
<?php } ?>

<hr style="margin: 40px 0;">

<div class="seo-aeo-info-box" style="background: #f9f9f9; border-left: 4px solid #666; padding: 15px;">
    <h3 style="margin-top: 0;"><?php _e('Plugin Information', 'seo-aeo-optimizer'); ?></h3>
    <p><strong><?php _e('Version:', 'seo-aeo-optimizer'); ?></strong> <?php echo SEO_AEO_VERSION; ?></p>
    <p><strong><?php _e('Developer:', 'seo-aeo-optimizer'); ?></strong> SmoothByte IT</p>
    <p><strong><?php _e('Documentation:', 'seo-aeo-optimizer'); ?></strong> <a href="#">View Docs</a></p>
</div>
