<?php if (!defined('ABSPATH')) exit; ?>

<h2><?php _e('XML Sitemap Settings', 'seo-aeo-optimizer'); ?></h2>
<p><?php _e('Configure automatic XML sitemap generation for better search engine indexing.', 'seo-aeo-optimizer'); ?></p>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Enable Sitemap', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[sitemap_enabled]" value="1" <?php checked(isset($options['sitemap_enabled']) ? $options['sitemap_enabled'] : true, true); ?> />
                <?php _e('Generate XML sitemaps automatically', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Creates dynamic XML sitemaps for all public content types.', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Include Post Types', 'seo-aeo-optimizer'); ?></th>
        <td>
            <?php
            $post_types = get_post_types(array('public' => true), 'objects');
            $selected_types = isset($options['sitemap_post_types']) ? $options['sitemap_post_types'] : array('post', 'page');
            
            foreach ($post_types as $post_type):
                if (in_array($post_type->name, array('attachment', 'revision', 'nav_menu_item'))):
                    continue;
                endif;
            ?>
                <label style="display: block; margin: 8px 0;">
                    <input type="checkbox" 
                           name="seo_aeo_options[sitemap_post_types][]" 
                           value="<?php echo esc_attr($post_type->name); ?>"
                           <?php checked(in_array($post_type->name, $selected_types)); ?> />
                    <?php echo esc_html($post_type->labels->name); ?> 
                    <small style="color: #666;">(<?php echo $post_type->name; ?>)</small>
                </label>
            <?php endforeach; ?>
            <p class="description"><?php _e('Select which post types to include in the sitemap.', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Sitemap URLs', 'seo-aeo-optimizer'); ?></th>
        <td>
            <?php if ($options['sitemap_enabled']): ?>
                <p><strong><?php _e('Main Sitemap Index:', 'seo-aeo-optimizer'); ?></strong><br>
                <a href="<?php echo home_url('/sitemap.xml'); ?>" target="_blank" style="color: #667eea;">
                    <?php echo home_url('/sitemap.xml'); ?>
                </a>
                <button type="button" class="button button-small" onclick="window.open('<?php echo home_url('/sitemap.xml'); ?>', '_blank')" style="margin-left: 10px;">
                    <?php _e('View', 'seo-aeo-optimizer'); ?>
                </button>
                </p>

                <p><strong><?php _e('Individual Sitemaps:', 'seo-aeo-optimizer'); ?></strong></p>
                <ul style="margin-left: 20px;">
                    <?php foreach ($selected_types as $type): ?>
                        <li>
                            <a href="<?php echo home_url("/sitemap-{$type}.xml"); ?>" target="_blank" style="color: #667eea;">
                                <?php echo home_url("/sitemap-{$type}.xml"); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>

                <p style="margin-top: 15px;">
                    <button type="button" class="button" onclick="clearSitemapCache()">
                        <?php _e('🔄 Clear Sitemap Cache', 'seo-aeo-optimizer'); ?>
                    </button>
                    <button type="button" class="button" onclick="pingSitemaps()">
                        <?php _e('📡 Ping Search Engines', 'seo-aeo-optimizer'); ?>
                    </button>
                </p>
            <?php else: ?>
                <p style="color: #999;">
                    <?php _e('Enable sitemap generation to view sitemap URLs.', 'seo-aeo-optimizer'); ?>
                </p>
            <?php endif; ?>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Features', 'seo-aeo-optimizer'); ?></th>
        <td>
            <ul style="list-style: disc; margin-left: 20px; line-height: 1.8;">
                <li><?php _e('✅ Automatic generation and caching (24 hour cache)', 'seo-aeo-optimizer'); ?></li>
                <li><?php _e('✅ Includes featured images in sitemap', 'seo-aeo-optimizer'); ?></li>
                <li><?php _e('✅ Automatic cache flush on content updates', 'seo-aeo-optimizer'); ?></li>
                <li><?php _e('✅ Optimized changefreq and priority per post type', 'seo-aeo-optimizer'); ?></li>
                <li><?php _e('✅ Automatically added to robots.txt', 'seo-aeo-optimizer'); ?></li>
                <li><?php _e('✅ Compatible with all custom post types', 'seo-aeo-optimizer'); ?></li>
                <li><?php _e('✅ Google XML Sitemap format compliant', 'seo-aeo-optimizer'); ?></li>
            </ul>
        </td>
    </tr>
</table>

<script>
jQuery(document).ready(function($) {
    window.clearSitemapCache = function() {
        if (!confirm('<?php _e('This will refresh all sitemap caches. Continue?', 'seo-aeo-optimizer'); ?>')) {
            return;
        }
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'seo_aeo_clear_sitemap_cache',
                nonce: '<?php echo wp_create_nonce('seo_aeo_admin'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    alert('<?php _e('✓ Sitemap cache cleared successfully!', 'seo-aeo-optimizer'); ?>');
                } else {
                    alert('<?php _e('Error clearing cache', 'seo-aeo-optimizer'); ?>');
                }
            }
        });
    };
    
    window.pingSitemaps = function() {
        if (!confirm('<?php _e('This will notify Google and Bing about your sitemap. Continue?', 'seo-aeo-optimizer'); ?>')) {
            return;
        }
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'seo_aeo_ping_sitemap',
                nonce: '<?php echo wp_create_nonce('seo_aeo_admin'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    alert('<?php _e('✓ Search engines pinged successfully!', 'seo-aeo-optimizer'); ?>');
                } else {
                    alert('<?php _e('Error pinging search engines', 'seo-aeo-optimizer'); ?>');
                }
            }
        });
    };
});
</script>
