<?php if (!defined('ABSPATH')) exit; ?>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Enable Schema Markup', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema]" value="1" <?php checked($options['schema'], true); ?> />
                <?php _e('Enable JSON-LD structured data', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Add Schema.org markup for better search engine understanding', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Organization Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_organization]" value="1" <?php checked($options['schema_organization'], true); ?> />
                <?php _e('Add Organization schema on homepage', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Product Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_product]" value="1" <?php checked($options['schema_product'], true); ?> />
                <?php _e('Add Product schema for product/lot post types', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Article Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_article]" value="1" <?php checked($options['schema_article'], true); ?> />
                <?php _e('Add Article schema for posts and pages', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Breadcrumb Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_breadcrumb]" value="1" <?php checked($options['schema_breadcrumb'], true); ?> />
                <?php _e('Add BreadcrumbList schema for navigation', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('FAQ Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_faq]" value="1" <?php checked($options['schema_faq'], true); ?> />
                <?php _e('Add FAQ schema (configure in FAQ tab)', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Cache Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[cache_schema]" value="1" <?php checked($options['cache_schema'], true); ?> />
                <?php _e('Cache generated schema markup for better performance', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>
</table>

<div class="seo-aeo-info-box" style="background: #e1f5fe; border-left: 4px solid #03a9f4; padding: 15px; margin: 20px 0;">
    <h3 style="margin-top: 0;">🚀 <?php _e('More Schema Types Available', 'seo-aeo-optimizer'); ?></h3>
    <p><?php _e('Looking for more advanced schema types? Check out the <strong>Advanced</strong> tab for:', 'seo-aeo-optimizer'); ?></p>
    <ul>
        <li>✨ Event Schema (auctions, webinars, sales)</li>
        <li>⭐ Review/Rating Schema</li>
        <li>🎥 Video Schema</li>
        <li>📖 HowTo Schema (for step-by-step guides - perfect for AEO)</li>
        <li>🎤 Speakable Schema (voice search optimization)</li>
    </ul>
    <p><a href="?page=seo-aeo-optimizer&tab=advanced" class="button button-secondary"><?php _e('→ Go to Advanced Schema Settings', 'seo-aeo-optimizer'); ?></a></p>
</div>

<div class="seo-aeo-info-box" style="background: #f0f6fc; border-left: 4px solid #0073aa; padding: 15px; margin: 20px 0;">
    <h3 style="margin-top: 0;"><?php _e('What is Schema Markup?', 'seo-aeo-optimizer'); ?></h3>
    <p><?php _e('Schema markup (structured data) helps search engines and AI systems understand your content better. This leads to:', 'seo-aeo-optimizer'); ?></p>
    <ul>
        <li><?php _e('Rich snippets in Google search results', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('Better indexing by AI platforms (ChatGPT, Claude, Perplexity)', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('Featured snippets and knowledge panels', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('Voice search optimization', 'seo-aeo-optimizer'); ?></li>
    </ul>
    <p>
        <strong><?php _e('Test your schema:', 'seo-aeo-optimizer'); ?></strong>
        <a href="https://search.google.com/test/rich-results" target="_blank">Google Rich Results Test</a> |
        <a href="https://validator.schema.org/" target="_blank">Schema.org Validator</a>
    </p>
</div>
