<?php if (!defined('ABSPATH')) exit; ?>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Enable Meta Tags', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[meta_tags]" value="1" <?php checked($options['meta_tags'], true); ?> />
                <?php _e('Enable social media meta tags', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Generate Open Graph and Twitter Card meta tags', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Open Graph Tags', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[og_tags]" value="1" <?php checked($options['og_tags'], true); ?> />
                <?php _e('Enable Open Graph meta tags for Facebook, LinkedIn, Discord', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Improves social media sharing previews', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Twitter Cards', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[twitter_cards]" value="1" <?php checked($options['twitter_cards'], true); ?> />
                <?php _e('Enable Twitter Card meta tags', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Optimizes tweets with rich media previews', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<div class="seo-aeo-info-box" style="background: #e7f3e7; border-left: 4px solid #46b450; padding: 15px; margin: 20px 0;">
    <h3 style="margin-top: 0;"><?php _e('Test Your Meta Tags', 'seo-aeo-optimizer'); ?></h3>
    <p><?php _e('Use these tools to verify your meta tags are working correctly:', 'seo-aeo-optimizer'); ?></p>
    <ul>
        <li><a href="https://developers.facebook.com/tools/debug/" target="_blank">Facebook Sharing Debugger</a> - Test Open Graph tags</li>
        <li><a href="https://cards-dev.twitter.com/validator" target="_blank">Twitter Card Validator</a> - Test Twitter cards</li>
        <li><a href="https://www.linkedin.com/post-inspector/" target="_blank">LinkedIn Post Inspector</a> - Test LinkedIn previews</li>
    </ul>
</div>
