<?php if (!defined('ABSPATH')) exit; ?>

<h2><?php _e('Local SEO / GEO Settings', 'seo-aeo-optimizer'); ?></h2>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Enable Local SEO', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[local_seo_enabled]" value="1" <?php checked($options['local_seo_enabled'], true); ?> />
                <?php _e('Enable LocalBusiness schema and geographic optimization', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Essential for businesses with physical locations or serving specific geographic areas', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Business Type', 'seo-aeo-optimizer'); ?></th>
        <td>
            <select name="seo_aeo_options[local_business_type]">
                <option value="LocalBusiness" <?php selected($options['local_business_type'], 'LocalBusiness'); ?>>Local Business</option>
                <option value="Restaurant" <?php selected($options['local_business_type'], 'Restaurant'); ?>>Restaurant</option>
                <option value="Store" <?php selected($options['local_business_type'], 'Store'); ?>>Store</option>
                <option value="ProfessionalService" <?php selected($options['local_business_type'], 'ProfessionalService'); ?>>Professional Service</option>
                <option value="HealthAndBeautyBusiness" <?php selected($options['local_business_type'], 'HealthAndBeautyBusiness'); ?>>Health & Beauty</option>
                <option value="AutoDealer" <?php selected($options['local_business_type'], 'AutoDealer'); ?>>Auto Dealer</option>
                <option value="RealEstateAgent" <?php selected($options['local_business_type'], 'RealEstateAgent'); ?>>Real Estate Agent</option>
            </select>
            <p class="description"><?php _e('Select the type that best describes your business', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<h3><?php _e('NAP (Name, Address, Phone)', 'seo-aeo-optimizer'); ?></h3>
<p><?php _e('Consistent NAP information improves local search rankings', 'seo-aeo-optimizer'); ?></p>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Street Address', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="text" name="seo_aeo_options[local_street_address]" value="<?php echo esc_attr($options['local_street_address'] ?? ''); ?>" class="regular-text" placeholder="123 Main Street" />
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('City', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="text" name="seo_aeo_options[local_city]" value="<?php echo esc_attr($options['local_city'] ?? ''); ?>" class="regular-text" placeholder="Tel Aviv" />
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('State / Region', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="text" name="seo_aeo_options[local_state]" value="<?php echo esc_attr($options['local_state'] ?? ''); ?>" class="regular-text" placeholder="Tel Aviv District" />
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Postal Code', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="text" name="seo_aeo_options[local_postal_code]" value="<?php echo esc_attr($options['local_postal_code'] ?? ''); ?>" class="regular-text" placeholder="61000" />
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Country', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="text" name="seo_aeo_options[local_country]" value="<?php echo esc_attr($options['local_country'] ?? ''); ?>" class="regular-text" placeholder="IL" />
            <p class="description"><?php _e('Use 2-letter country code (e.g., IL, US, GB)', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Phone Number', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="tel" name="seo_aeo_options[local_phone]" value="<?php echo esc_attr($options['local_phone'] ?? ''); ?>" class="regular-text" placeholder="+972-3-123-4567" />
            <p class="description"><?php _e('Include country code for better recognition', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Email', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="email" name="seo_aeo_options[local_email]" value="<?php echo esc_attr($options['local_email'] ?? ''); ?>" class="regular-text" placeholder="info@yourbusiness.com" />
        </td>
    </tr>
</table>

<h3><?php _e('Geographic Coordinates', 'seo-aeo-optimizer'); ?></h3>
<p><?php _e('Add precise coordinates for better local search results and map integration', 'seo-aeo-optimizer'); ?></p>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Latitude', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="text" name="seo_aeo_options[local_latitude]" value="<?php echo esc_attr($options['local_latitude'] ?? ''); ?>" class="regular-text" placeholder="32.0853" />
            <p class="description"><?php _e('Example: 32.0853 (find on Google Maps)', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Longitude', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="text" name="seo_aeo_options[local_longitude]" value="<?php echo esc_attr($options['local_longitude'] ?? ''); ?>" class="regular-text" placeholder="34.7818" />
            <p class="description"><?php _e('Example: 34.7818 (find on Google Maps)', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<h3><?php _e('Additional Business Information', 'seo-aeo-optimizer'); ?></h3>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Price Range', 'seo-aeo-optimizer'); ?></th>
        <td>
            <select name="seo_aeo_options[local_price_range]">
                <option value="">Not specified</option>
                <option value="$" <?php selected($options['local_price_range'] ?? '', '$'); ?>>$ (Inexpensive)</option>
                <option value="$$" <?php selected($options['local_price_range'] ?? '', '$$'); ?>>$$ (Moderate)</option>
                <option value="$$$" <?php selected($options['local_price_range'] ?? '', '$$$'); ?>>$$$ (Expensive)</option>
                <option value="$$$$" <?php selected($options['local_price_range'] ?? '', '$$$$'); ?>>$$$$ (Very Expensive)</option>
            </select>
            <p class="description"><?php _e('Helps customers understand your pricing level', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Opening Hours', 'seo-aeo-optimizer'); ?></th>
        <td>
            <textarea name="seo_aeo_options[local_opening_hours]" rows="5" class="large-text" placeholder="Mo-Fr 09:00-18:00&#10;Sa 10:00-16:00&#10;Su closed"><?php echo esc_textarea(is_array($options['local_opening_hours'] ?? '') ? implode("\n", $options['local_opening_hours']) : ($options['local_opening_hours'] ?? '')); ?></textarea>
            <p class="description"><?php _e('Format: Mo-Fr 09:00-18:00 (one per line)', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Service Areas', 'seo-aeo-optimizer'); ?></th>
        <td>
            <textarea name="seo_aeo_options[local_service_areas]" rows="3" class="large-text" placeholder="Tel Aviv&#10;Ramat Gan&#10;Givatayim"><?php echo esc_textarea(is_array($options['local_service_areas'] ?? '') ? implode("\n", $options['local_service_areas']) : ($options['local_service_areas'] ?? '')); ?></textarea>
            <p class="description"><?php _e('Cities/areas you serve (one per line)', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<div class="seo-aeo-info-box" style="background: #e8f5e9; border-left: 4px solid #4caf50; padding: 15px; margin: 20px 0;">
    <h3 style="margin-top: 0;">🗺️ <?php _e('Local SEO / GEO Benefits', 'seo-aeo-optimizer'); ?></h3>
    <ul>
        <li><?php _e('<strong>Google Maps:</strong> Appear in local map results', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>"Near Me" Searches:</strong> Show up for location-based queries', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>Google Business Profile:</strong> Enhanced integration', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>Voice Assistants:</strong> Better recognition for "Find X near me"', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>AI Recommendations:</strong> ChatGPT/Claude can suggest your business for local queries', 'seo-aeo-optimizer'); ?></li>
    </ul>
    <p>
        <strong><?php _e('Pro Tip:', 'seo-aeo-optimizer'); ?></strong>
        <?php _e('Make sure your NAP information is consistent across your website, Google Business Profile, and all online directories.', 'seo-aeo-optimizer'); ?>
    </p>
</div>
