<?php if (!defined('ABSPATH')) exit; ?>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Enable Plugin', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[enabled]" value="1" <?php checked(isset($options['enabled']) ? $options['enabled'] : true, true); ?> />
                <?php _e('Enable SEO & AEO optimization features', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Turn on/off all plugin features globally.', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Organization Name', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="text" name="seo_aeo_options[org_name]" value="<?php echo esc_attr($options['org_name']); ?>" class="regular-text" />
            <p class="description"><?php _e('Your business/organization name', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Organization URL', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="url" name="seo_aeo_options[org_url]" value="<?php echo esc_url($options['org_url']); ?>" class="regular-text" />
            <p class="description"><?php _e('Your website URL', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Organization Logo', 'seo-aeo-optimizer'); ?></th>
        <td>
            <input type="url" name="seo_aeo_options[org_logo]" value="<?php echo esc_url($options['org_logo']); ?>" class="regular-text" id="org_logo" />
            <button type="button" class="button" id="upload_logo_button"><?php _e('Upload Logo', 'seo-aeo-optimizer'); ?></button>
            <p class="description"><?php _e('URL to your organization logo (min 600x60px recommended)', 'seo-aeo-optimizer'); ?></p>
            <?php if (!empty($options['org_logo'])): ?>
                <p><img src="<?php echo esc_url($options['org_logo']); ?>" style="max-width: 200px; height: auto;" /></p>
            <?php endif; ?>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Organization Description', 'seo-aeo-optimizer'); ?></th>
        <td>
            <textarea name="seo_aeo_options[org_description]" rows="3" class="large-text"><?php echo esc_textarea($options['org_description']); ?></textarea>
            <p class="description"><?php _e('Brief description of your organization', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Social Media Links', 'seo-aeo-optimizer'); ?></th>
        <td>
            <div id="social-links-container">
                <?php
                $social_links = $options['org_social_links'] ?? array();
                if (empty($social_links)) {
                    $social_links = array('');
                }
                foreach ($social_links as $index => $link):
                ?>
                <p>
                    <input type="url" name="seo_aeo_options[org_social_links][]" value="<?php echo esc_url($link); ?>" class="regular-text" placeholder="https://facebook.com/yourpage" />
                    <button type="button" class="button remove-social-link" <?php echo $index === 0 ? 'style="display:none;"' : ''; ?>>Remove</button>
                </p>
                <?php endforeach; ?>
            </div>
            <button type="button" class="button" id="add-social-link"><?php _e('Add Social Link', 'seo-aeo-optimizer'); ?></button>
            <p class="description"><?php _e('Add your social media profile URLs (Facebook, Twitter, Instagram, LinkedIn, etc.)', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<script>
jQuery(document).ready(function($) {
    // Add social link
    $('#add-social-link').on('click', function() {
        var html = '<p><input type="url" name="seo_aeo_options[org_social_links][]" value="" class="regular-text" placeholder="https://facebook.com/yourpage" />' +
                   '<button type="button" class="button remove-social-link">Remove</button></p>';
        $('#social-links-container').append(html);
    });
    
    // Remove social link
    $(document).on('click', '.remove-social-link', function() {
        $(this).parent().remove();
    });
    
    // Media uploader for logo
    $('#upload_logo_button').on('click', function(e) {
        e.preventDefault();
        var image = wp.media({
            title: 'Upload Logo',
            multiple: false
        }).open().on('select', function(){
            var uploaded_image = image.state().get('selection').first();
            var image_url = uploaded_image.toJSON().url;
            $('#org_logo').val(image_url);
        });
    });
});
</script>
