<?php if (!defined('ABSPATH')) exit; ?>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Enable FAQ Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[faq_enabled]" value="1" <?php checked($options['faq_enabled'], true); ?> />
                <?php _e('Add FAQ schema to your site', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('FAQ schema helps AI and search engines provide direct answers to common questions', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<h3><?php _e('FAQ Items', 'seo-aeo-optimizer'); ?></h3>
<p><?php _e('Add frequently asked questions that will be included as structured data on your site.', 'seo-aeo-optimizer'); ?></p>

<div id="faq-items-container">
    <?php
    $faq_items = $options['faq_items'] ?? array();
    if (empty($faq_items)) {
        $faq_items = array(array('question' => '', 'answer' => ''));
    }
    
    foreach ($faq_items as $index => $item):
    ?>
    <div class="faq-item" style="background: #f9f9f9; padding: 15px; margin-bottom: 15px; border-radius: 4px;">
        <p>
            <label><strong><?php _e('Question', 'seo-aeo-optimizer'); ?></strong></label><br>
            <input type="text" name="seo_aeo_options[faq_items][<?php echo $index; ?>][question]" 
                   value="<?php echo esc_attr($item['question'] ?? ''); ?>" 
                   class="widefat" 
                   placeholder="<?php _e('e.g., How do I place a bid?', 'seo-aeo-optimizer'); ?>" />
        </p>
        <p>
            <label><strong><?php _e('Answer', 'seo-aeo-optimizer'); ?></strong></label><br>
            <textarea name="seo_aeo_options[faq_items][<?php echo $index; ?>][answer]" 
                      rows="3" 
                      class="widefat"
                      placeholder="<?php _e('Provide a detailed answer...', 'seo-aeo-optimizer'); ?>"><?php echo esc_textarea($item['answer'] ?? ''); ?></textarea>
        </p>
        <button type="button" class="button remove-faq-item"><?php _e('Remove FAQ', 'seo-aeo-optimizer'); ?></button>
    </div>
    <?php endforeach; ?>
</div>

<button type="button" class="button button-primary" id="add-faq-item"><?php _e('Add FAQ Item', 'seo-aeo-optimizer'); ?></button>

<script>
jQuery(document).ready(function($) {
    var faqIndex = <?php echo count($faq_items); ?>;
    
    $('#add-faq-item').on('click', function() {
        var html = '<div class="faq-item" style="background: #f9f9f9; padding: 15px; margin-bottom: 15px; border-radius: 4px;">' +
            '<p><label><strong><?php _e('Question', 'seo-aeo-optimizer'); ?></strong></label><br>' +
            '<input type="text" name="seo_aeo_options[faq_items][' + faqIndex + '][question]" class="widefat" placeholder="<?php _e('e.g., How do I place a bid?', 'seo-aeo-optimizer'); ?>" /></p>' +
            '<p><label><strong><?php _e('Answer', 'seo-aeo-optimizer'); ?></strong></label><br>' +
            '<textarea name="seo_aeo_options[faq_items][' + faqIndex + '][answer]" rows="3" class="widefat" placeholder="<?php _e('Provide a detailed answer...', 'seo-aeo-optimizer'); ?>"></textarea></p>' +
            '<button type="button" class="button remove-faq-item"><?php _e('Remove FAQ', 'seo-aeo-optimizer'); ?></button>' +
            '</div>';
        
        $('#faq-items-container').append(html);
        faqIndex++;
    });
    
    $(document).on('click', '.remove-faq-item', function() {
        $(this).parent().remove();
    });
});
</script>

<div class="seo-aeo-info-box" style="background: #e5f5fa; border-left: 4px solid #00a0d2; padding: 15px; margin: 20px 0;">
    <h3 style="margin-top: 0;"><?php _e('FAQ Schema Benefits', 'seo-aeo-optimizer'); ?></h3>
    <p><?php _e('Adding FAQ schema markup provides several advantages:', 'seo-aeo-optimizer'); ?></p>
    <ul>
        <li><?php _e('<strong>Featured Snippets:</strong> Your FAQs may appear as expanded results in Google', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>AI Answers:</strong> ChatGPT, Claude, and Perplexity can cite your FAQs directly', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>Voice Search:</strong> Perfect format for voice assistants (Alexa, Google Assistant)', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>More Visibility:</strong> Takes up more space in search results', 'seo-aeo-optimizer'); ?></li>
    </ul>
</div>
