<?php if (!defined('ABSPATH')) exit; ?>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Enable Robots.txt Optimization', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[robots]" value="1" <?php checked($options['robots'], true); ?> />
                <?php _e('Optimize robots.txt for AI crawlers', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Adds specific rules for AI crawlers to index your content', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Allow GPTBot (ChatGPT)', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[allow_gptbot]" value="1" <?php checked($options['allow_gptbot'], true); ?> />
                <?php _e('Allow OpenAI\'s ChatGPT to crawl and index your site', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Allow CCBot (Common Crawl)', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[allow_ccbot]" value="1" <?php checked($options['allow_ccbot'], true); ?> />
                <?php _e('Allow Common Crawl bot (used by many AI services)', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Allow Anthropic AI (Claude)', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[allow_anthropic]" value="1" <?php checked($options['allow_anthropic'], true); ?> />
                <?php _e('Allow Anthropic\'s Claude AI to access your content', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Allow PerplexityBot', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[allow_perplexity]" value="1" <?php checked($options['allow_perplexity'], true); ?> />
                <?php _e('Allow Perplexity AI search engine to crawl', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Allow YouBot (You.com)', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[allow_youbot]" value="1" <?php checked($options['allow_youbot'], true); ?> />
                <?php _e('Allow You.com AI search to index your site', 'seo-aeo-optimizer'); ?>
            </label>
        </td>
    </tr>
</table>

<div class="seo-aeo-info-box" style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0;">
    <h3 style="margin-top: 0;">⚠️ <?php _e('Important: AI Crawler Access', 'seo-aeo-optimizer'); ?></h3>
    <p><?php _e('Allowing AI crawlers means:', 'seo-aeo-optimizer'); ?></p>
    <ul>
        <li><?php _e('<strong>Training Data:</strong> Your content may be used to train AI models', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>Answer Engines:</strong> AI systems can cite and quote your content in responses', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>Increased Visibility:</strong> Your content becomes discoverable through AI-powered search', 'seo-aeo-optimizer'); ?></li>
        <li><?php _e('<strong>Server Load:</strong> May increase server requests from AI crawlers', 'seo-aeo-optimizer'); ?></li>
    </ul>
    <p>
        <strong><?php _e('Check your robots.txt:', 'seo-aeo-optimizer'); ?></strong>
        <a href="<?php echo home_url('/robots.txt'); ?>" target="_blank"><?php echo home_url('/robots.txt'); ?></a>
    </p>
</div>
