<?php if (!defined('ABSPATH')) exit; ?>

<!-- Hidden field to identify this tab -->
<input type="hidden" name="seo_aeo_options[_tab_advanced]" value="1" />

<h2><?php _e('Advanced Schema & Technical SEO', 'seo-aeo-optimizer'); ?></h2>

<h3><?php _e('Advanced Schema Types', 'seo-aeo-optimizer'); ?></h3>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Event Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_event]" value="1" <?php checked($options['schema_event'] ?? false, true); ?> />
                <?php _e('Enable Event schema for auctions, sales, webinars', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Perfect for auction events, sales, conferences, etc. Requires _event_date custom field', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Review/Rating Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_review]" value="1" <?php checked($options['schema_review'] ?? false, true); ?> />
                <?php _e('Enable Review and Rating schema', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Shows star ratings in search results. Requires _rating custom field', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Video Schema', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_video]" value="1" <?php checked($options['schema_video'] ?? false, true); ?> />
                <?php _e('Enable Video schema', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('For video content and thumbnails. Requires _video_url custom field', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('HowTo Schema (AEO)', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_howto]" value="1" <?php checked($options['schema_howto'] ?? false, true); ?> />
                <?php _e('Enable HowTo schema for step-by-step guides', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Perfect for tutorials and guides. AI-friendly for answer engines', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Speakable Schema (Voice)', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[schema_speakable]" value="1" <?php checked($options['schema_speakable'] ?? false, true); ?> />
                <?php _e('Enable Speakable schema for voice assistants', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Optimizes content for voice search (Alexa, Google Assistant, Siri)', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<hr style="margin: 30px 0;">

<h3><?php _e('Technical SEO Settings', 'seo-aeo-optimizer'); ?></h3>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Canonical URLs', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[canonical_enabled]" value="1" <?php checked($options['canonical_enabled'] ?? true, true); ?> />
                <?php _e('Automatically add canonical URLs', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Prevents duplicate content issues', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Image Optimization', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[image_optimization]" value="1" <?php checked($options['image_optimization'] ?? true, true); ?> />
                <?php _e('Add loading="lazy" and optimize image attributes', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Improves page load speed and Core Web Vitals', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('DNS Prefetch', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[dns_prefetch]" value="1" <?php checked($options['dns_prefetch'] ?? true, true); ?> />
                <?php _e('Add DNS prefetch and preconnect hints', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Speeds up external resource loading', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<h3><?php _e('Meta Robots Control', 'seo-aeo-optimizer'); ?></h3>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('NoIndex Archives', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[noindex_archives]" value="1" <?php checked($options['noindex_archives'] ?? false, true); ?> />
                <?php _e('Add noindex to archive pages', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Prevents category/tag pages from being indexed', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('NoIndex Search Results', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[noindex_search]" value="1" <?php checked($options['noindex_search'] ?? true, true); ?> />
                <?php _e('Add noindex to search result pages', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Recommended: Prevents duplicate content', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('NoIndex Paginated Pages', 'seo-aeo-optimizer'); ?></th>
        <td>
            <label>
                <input type="checkbox" name="seo_aeo_options[noindex_paginated]" value="1" <?php checked($options['noindex_paginated'] ?? false, true); ?> />
                <?php _e('Add noindex to page 2, 3, etc.', 'seo-aeo-optimizer'); ?>
            </label>
            <p class="description"><?php _e('Use if you have pagination issues', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<h3><?php _e('Search Engine Directives', 'seo-aeo-optimizer'); ?></h3>

<table class="form-table">
    <tr>
        <th scope="row"><?php _e('Max Image Preview', 'seo-aeo-optimizer'); ?></th>
        <td>
            <select name="seo_aeo_options[max_image_preview]">
                <option value="none" <?php selected($options['max_image_preview'] ?? 'large', 'none'); ?>>None</option>
                <option value="standard" <?php selected($options['max_image_preview'] ?? 'large', 'standard'); ?>>Standard</option>
                <option value="large" <?php selected($options['max_image_preview'] ?? 'large', 'large'); ?>>Large (Recommended)</option>
            </select>
            <p class="description"><?php _e('Controls image preview size in search results', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Max Snippet Length', 'seo-aeo-optimizer'); ?></th>
        <td>
            <select name="seo_aeo_options[max_snippet]">
                <option value="-1" <?php selected($options['max_snippet'] ?? '-1', '-1'); ?>>No Limit (Recommended)</option>
                <option value="0" <?php selected($options['max_snippet'] ?? '-1', '0'); ?>>No Snippet</option>
                <option value="160" <?php selected($options['max_snippet'] ?? '-1', '160'); ?>>160 characters</option>
                <option value="320" <?php selected($options['max_snippet'] ?? '-1', '320'); ?>>320 characters</option>
            </select>
            <p class="description"><?php _e('Maximum text length for search snippets. -1 = unlimited', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>

    <tr>
        <th scope="row"><?php _e('Max Video Preview', 'seo-aeo-optimizer'); ?></th>
        <td>
            <select name="seo_aeo_options[max_video_preview]">
                <option value="-1" <?php selected($options['max_video_preview'] ?? '-1', '-1'); ?>>No Limit (Recommended)</option>
                <option value="0" <?php selected($options['max_video_preview'] ?? '-1', '0'); ?>>No Preview</option>
            </select>
            <p class="description"><?php _e('Maximum video preview duration in search results', 'seo-aeo-optimizer'); ?></p>
        </td>
    </tr>
</table>

<div class="seo-aeo-info-box" style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0;">
    <h3 style="margin-top: 0;">⚡ <?php _e('Advanced Features Explained', 'seo-aeo-optimizer'); ?></h3>
    
    <p><strong><?php _e('For AEO (Answer Engine Optimization):', 'seo-aeo-optimizer'); ?></strong></p>
    <ul>
        <li><strong>HowTo Schema:</strong> <?php _e('Perfect for step-by-step guides - AI chatbots can cite your steps directly', 'seo-aeo-optimizer'); ?></li>
        <li><strong>Speakable Schema:</strong> <?php _e('Marks sections suitable for voice assistants to read aloud', 'seo-aeo-optimizer'); ?></li>
        <li><strong>Event Schema:</strong> <?php _e('AI can recommend your events when users ask about upcoming activities', 'seo-aeo-optimizer'); ?></li>
    </ul>

    <p><strong><?php _e('For Traditional SEO:', 'seo-aeo-optimizer'); ?></strong></p>
    <ul>
        <li><strong>Review Schema:</strong> <?php _e('Star ratings appear in Google search results', 'seo-aeo-optimizer'); ?></li>
        <li><strong>Video Schema:</strong> <?php _e('Videos appear in video search and can get rich snippets', 'seo-aeo-optimizer'); ?></li>
        <li><strong>Canonical URLs:</strong> <?php _e('Tells search engines which version of a page is the "master" copy', 'seo-aeo-optimizer'); ?></li>
    </ul>
</div>

<div class="seo-aeo-info-box" style="background: #e3f2fd; border-left: 4px solid #2196f3; padding: 15px; margin: 20px 0;">
    <h3 style="margin-top: 0;">📝 <?php _e('Custom Fields Required', 'seo-aeo-optimizer'); ?></h3>
    <p><?php _e('Some advanced schemas require custom fields on your posts:', 'seo-aeo-optimizer'); ?></p>
    <ul>
        <li><strong>Event Schema:</strong> _event_date, _event_end_date, _event_location</li>
        <li><strong>Review Schema:</strong> _rating, _review_count</li>
        <li><strong>Video Schema:</strong> _video_url, _video_thumbnail, _video_duration</li>
    </ul>
    <p><?php _e('You can add these using Advanced Custom Fields plugin or manually via post meta.', 'seo-aeo-optimizer'); ?></p>
</div>
