# Automatic Update Integration

## Overview

SEO & AEO Optimizer Pro now includes built-in automatic update functionality that integrates with the WP Plugin Deployer standalone server.

## Features

✅ **Automatic Update Checks** - Plugin checks for updates every 12 hours  
✅ **WordPress Integration** - Updates appear in WordPress Updates screen  
✅ **Manual Control** - Option to auto-install or review updates first  
✅ **Health Monitoring** - Reports plugin status back to deployment server  
✅ **Connection Testing** - Test deployment server connectivity  
✅ **Admin UI** - Easy configuration through plugin settings

## Configuration

### Step 1: Access Update Settings

1. Go to **WordPress Admin** → **SEO & AEO** → **Updates** tab
2. You'll see the automatic updates configuration page

### Step 2: Configure Deployment Server

**Deployment Server URL:**
```
https://wpdeploy.smoothbyteit.dev
```
(Or your custom deployment server URL)

**Site API Key:**
- Get this from the deployment server admin
- Or register the site using the master API key from the server

### Step 3: Configure Auto-Install

Choose whether updates should:
- ✅ **Install automatically** when deployed
- ❌ **Show notification** and require manual installation

### Step 4: Test Connection

Click **"Test Connection"** to verify:
- Server is reachable
- API key is valid
- Connection is working

### Step 5: Check for Updates

Click **"Check for Updates Now"** to:
- Force an immediate update check
- See if new versions are available
- Verify the update system is working

## How It Works

### Update Check Flow

1. **Scheduled Checks**
   - Plugin checks for updates every 12 hours (WordPress default)
   - Checks for pending deployments every hour
   - Reports health status twice daily

2. **Deployment Server Communication**
   - Sends current plugin version to server
   - Receives available updates if any
   - Downloads and verifies checksums

3. **WordPress Integration**
   - Updates appear in Dashboard → Updates
   - Can be installed through standard WordPress update flow
   - Or automatically if auto-install is enabled

4. **Status Reporting**
   - Reports installation success/failure
   - Sends plugin status (active/inactive)
   - Reports WordPress & PHP versions
   - Monitors for errors

### API Endpoints Used

The plugin communicates with these deployment server endpoints:

```
POST /api.php/check-updates       - Check for available updates
GET  /api.php/pending-updates     - Get pending deployments
GET  /api.php/download/{slug}/{v} - Download plugin file
POST /api.php/update-deployed/{id}- Report installation status
POST /api.php/report-health       - Send health status
GET  /api.php/info                - Test connection
```

## Files Added

New files for update functionality:

```
includes/class-auto-updater.php   - Main updater class
admin/tabs/updates.php            - Admin settings UI
UPDATE-INTEGRATION.md             - This file
```

Modified files:
```
seo-aeo-optimizer.php             - Added updater initialization
admin/class-admin-settings.php    - Added Updates tab
```

## Benefits

### For Site Administrators
- ✅ Automatic update notifications
- ✅ Centralized update management
- ✅ No need to manually check for updates
- ✅ Health monitoring and error tracking

### For Developers
- ✅ Easy deployment to multiple sites
- ✅ Version control and rollback capability
- ✅ Update status tracking
- ✅ Plugin health monitoring across all sites

## Troubleshooting

### Updates Not Appearing

1. **Check Configuration**
   - Verify server URL is correct
   - Ensure API key is valid
   - Test connection using "Test Connection" button

2. **Force Update Check**
   - Go to Updates tab
   - Click "Check for Updates Now"
   - Check WordPress Dashboard → Updates

3. **Check Logs**
   - Deployment server logs at `/logs/app.log`
   - WordPress debug log if enabled

### Connection Errors

**Error: "Connection failed"**
- Check server URL is accessible
- Verify SSL certificate is valid
- Check firewall settings

**Error: "Invalid API key"**
- Re-enter API key from deployment server
- Ensure no extra spaces in API key
- Contact deployment server admin

### Auto-Install Not Working

1. Check auto-install is enabled in settings
2. Verify file permissions on plugins directory
3. Check for errors in WordPress debug log
4. Review deployment server status

## Security

- ✅ API key authentication for all requests
- ✅ HTTPS required for communication
- ✅ Checksum verification of downloaded files
- ✅ WordPress capability checks (manage_options)
- ✅ Nonce protection on AJAX requests

## Admin Notifications

Plugin will show admin notices if:
- ⚠️ Update server is not configured
- ✅ Connection successful
- 🔔 Updates available
- ❌ Connection or update errors

## Cron Schedule

Automatic tasks:
- **Every 12 hours**: Check for updates (WordPress default)
- **Hourly**: Check for pending deployments
- **Twice daily**: Report health status to server

## Support

For issues with automatic updates:

1. **Plugin Issues**: Contact plugin developer
2. **Deployment Server Issues**: Contact server administrator
3. **Connection Issues**: Check with hosting provider

## Version History

- **v2.1.0** - Automatic update integration (Current)
  - Full WP Plugin Deployer integration
  - Admin settings UI
  - Health monitoring
  - Connection testing
  - Version management
  
- **v2.0.0** - Initial release
  - Core SEO & AEO features
  - Schema.org markup
  - AI crawler support

---

**Last Updated**: November 2024  
**Plugin Version**: 2.1.0  
**Integration Version**: 1.0.0
