# SEO & AEO Optimizer Pro

**Version:** 2.7.0  
**Latest Update:** November 2024

Comprehensive SEO and Answer Engine Optimization (AEO) for WordPress with Schema.org markup, AI crawler support, advanced meta tags, and automatic update integration.

## Description

**SEO & AEO Optimizer Pro** is a powerful WordPress plugin that enhances your website's visibility across traditional search engines (Google, Bing) and modern AI-powered answer engines (ChatGPT, Claude, Perplexity). 

### Key Features

✅ **Schema.org Structured Data**
- Product schema for e-commerce
- Article schema for blog posts
- Organization schema
- Breadcrumb navigation
- FAQ schema for Q&A content
- Automatic JSON-LD generation

✅ **AI Crawler Optimization**
- Explicit support for GPTBot (ChatGPT)
- Claude AI (Anthropic)
- Perplexity AI
- CCBot (Common Crawl)
- YouBot (You.com)
- Optimized robots.txt

✅ **Social Media Meta Tags**
- Open Graph tags (Facebook, LinkedIn, Discord)
- Twitter Cards
- Automatic image optimization
- Custom previews per post type

✅ **Admin Dashboard**
- Easy-to-use settings interface
- Visual schema configuration
- FAQ management
- Validation tools
- Export/Import settings

✅ **Performance Optimized**
- Lightweight code
- Minimal database queries
- Schema caching
- No bloat

## Installation

### Method 1: Upload via WordPress Admin

1. Download the plugin ZIP file
2. Go to WordPress Admin → Plugins → Add New → Upload Plugin
3. Choose the ZIP file and click "Install Now"
4. Activate the plugin

### Method 2: FTP Upload

1. Extract the ZIP file
2. Upload the `seo-aeo-optimizer` folder to `/wp-content/plugins/`
3. Activate the plugin through the 'Plugins' menu in WordPress

### Method 3: WP-CLI

```bash
wp plugin install seo-aeo-optimizer.zip --activate
```

## Configuration

After activation, go to **WordPress Admin → SEO & AEO** to configure:

### General Settings
- Organization name and details
- Logo upload
- Social media profiles
- Contact information

### Schema Settings
- Enable/disable schema types
- Product schema configuration
- Article/Blog settings
- Breadcrumb options
- FAQ schema

### Meta Tags
- Open Graph tags
- Twitter Cards
- Custom meta descriptions

### AI Crawlers
- Allow/block specific AI bots
- Robots.txt optimization
- Crawler access control

### FAQ Management
- Add unlimited FAQs
- Automatic schema generation
- Perfect for voice search

### Validation Tools
- Google Rich Results Test
- Schema.org Validator
- Facebook Debugger
- Twitter Card Validator

## Usage

### Enable Basic Features

1. Navigate to **SEO & AEO → General**
2. Enable the plugin
3. Fill in your organization details
4. Save changes

### Configure Schema Markup

1. Go to **SEO & AEO → Schema**
2. Enable desired schema types
3. Save settings
4. Test using validation tools in the **Tools** tab

### Add FAQs

1. Visit **SEO & AEO → FAQ Schema**
2. Enable FAQ schema
3. Click "Add FAQ Item"
4. Enter question and answer
5. Save changes

### Manage AI Crawlers

1. Go to **SEO & AEO → AI Crawlers**
2. Enable robots.txt optimization
3. Select which AI bots to allow
4. Save and test at `yoursite.com/robots.txt`

### Export/Import Settings

**Export:**
1. Go to **SEO & AEO → Tools**
2. Click "Export Settings"
3. Save the JSON file

**Import:**
1. Go to **SEO & AEO → Tools**
2. Upload a previously exported JSON file
3. Click "Import Settings"

## Frequently Asked Questions

### Does this plugin conflict with Yoast SEO or RankMath?

No, the plugin is designed to work alongside other SEO plugins. It will automatically detect and avoid duplicate meta tags.

### Will this slow down my website?

No. The plugin is performance-optimized with:
- Minimal code execution
- Schema caching
- Conditional loading
- No external requests

### What post types are supported?

By default: posts, pages, and products. You can extend this via filters for custom post types.

### How do I test if schema is working?

1. Go to **SEO & AEO → Tools**
2. Use the validation links provided
3. Or visit: https://search.google.com/test/rich-results

### Can I use this on multiple sites?

Yes! Use the Export/Import feature to transfer settings between sites.

### Does this help with AI search like ChatGPT?

Yes! The plugin explicitly allows AI crawlers to index your content, making it available to:
- ChatGPT (OpenAI)
- Claude (Anthropic)
- Perplexity
- You.com
- Other AI-powered search engines

## Developer Hooks

### Filters

**Modify product schema:**
```php
add_filter('seo_aeo_product_schema', function($schema, $post) {
    $schema['brand'] = 'My Brand';
    return $schema;
}, 10, 2);
```

**Modify article schema:**
```php
add_filter('seo_aeo_article_schema', function($schema, $post) {
    $schema['keywords'] = get_post_meta($post->ID, 'keywords', true);
    return $schema;
}, 10, 2);
```

**Add custom product post types:**
```php
add_filter('seo_aeo_product_post_types', function($types) {
    $types[] = 'lot';
    $types[] = 'auction';
    return $types;
});
```

**Modify meta data:**
```php
add_filter('seo_aeo_meta_data', function($data) {
    $data['title'] = 'Custom ' . $data['title'];
    return $data;
});
```

**Add custom FAQs:**
```php
add_filter('bp_auction_faqs', function($faqs) {
    $faqs[] = array(
        'question' => 'Your question?',
        'answer' => 'Your answer.'
    );
    return $faqs;
});
```

### Actions

**Before schema output:**
```php
add_action('seo_aeo_before_schema', function() {
    // Your code
});
```

**After plugin initialization:**
```php
add_action('seo_aeo_initialized', function() {
    // Your code
});
```

## Changelog

### Version 1.0.0 (2025-11-23)
- Initial release
- Schema.org structured data support
- AI crawler optimization
- Social media meta tags
- Admin settings panel
- FAQ schema management
- Export/Import functionality
- Validation tools integration

## Support

For support, feature requests, or bug reports:
- **Email:** support@smoothbyteit.dev
- **Documentation:** https://smoothbyteit.dev/docs/seo-aeo-optimizer

## License

GPL v2 or later

## Credits

Developed by **SmoothByte IT**
https://smoothbyteit.dev

## Requirements

- WordPress 5.8 or higher
- PHP 7.4 or higher
- Recommended: SSL certificate for better SEO

## Compatibility

- ✅ WordPress 6.0+
- ✅ WooCommerce
- ✅ Elementor
- ✅ Yoast SEO
- ✅ RankMath
- ✅ SmartCrawl Pro
- ✅ Multisite

## Privacy & Data

This plugin does NOT:
- Collect user data
- Make external API calls
- Track analytics
- Store personal information

All settings are stored locally in your WordPress database.

## Roadmap

- [ ] Video schema support
- [ ] Event schema
- [ ] Local Business schema
- [ ] Review schema
- [ ] AMP integration
- [ ] Gutenberg blocks
- [ ] AI content analysis
- [ ] Advanced analytics

---

**Made with ❤️ for better SEO and AI discoverability**
