# SEO & AEO Optimizer Pro - Installation Guide

## Quick Start

### 1. Activate the Plugin

**Via WordPress Admin:**
1. Log into your WordPress admin panel
2. Go to **Plugins → Installed Plugins**
3. Find "SEO & AEO Optimizer Pro"
4. Click **Activate**

**Via WP-CLI:**
```bash
wp plugin activate seo-aeo-optimizer
```

### 2. Initial Configuration (5 minutes)

After activation, navigate to **WordPress Admin → SEO & AEO**

#### Step 1: General Settings
- ✅ Enable the plugin (checkbox at top)
- Fill in your organization name
- Upload your logo (recommended: 600x60px minimum)
- Add organization description
- Add social media profile URLs

**Save Changes**

#### Step 2: Schema Settings
- ✅ Enable Schema Markup
- ✅ Enable Organization Schema
- ✅ Enable Product Schema (if you have products/e-commerce)
- ✅ Enable Article Schema (for blog posts)
- ✅ Enable Breadcrumb Schema
- ✅ Enable FAQ Schema

**Save Changes**

#### Step 3: Meta Tags
- ✅ Enable Meta Tags
- ✅ Enable Open Graph Tags
- ✅ Enable Twitter Cards

**Save Changes**

#### Step 4: AI Crawlers
- ✅ Enable Robots.txt Optimization
- ✅ Allow GPTBot (ChatGPT)
- ✅ Allow CCBot (Common Crawl)
- ✅ Allow Anthropic AI (Claude)
- ✅ Allow PerplexityBot
- ✅ Allow YouBot

**Save Changes**

### 3. Add FAQs (Optional but Recommended)

1. Go to **SEO & AEO → FAQ Schema**
2. ✅ Enable FAQ Schema
3. Click "Add FAQ Item"
4. Enter common questions and answers about your business
5. Recommended: Add at least 5-10 FAQs
6. **Save Changes**

### 4. Validate Your Setup

1. Go to **SEO & AEO → Tools**
2. Click "Test Homepage" under Google Rich Results Test
3. Verify no errors appear
4. Test Facebook sharing preview
5. Check robots.txt at: `yoursite.com/robots.txt`

---

## Verification Checklist

After installation, verify these items:

- [ ] Plugin activated without errors
- [ ] Organization details filled in General tab
- [ ] Schema markup enabled
- [ ] At least one schema type active (Product or Article)
- [ ] Meta tags enabled for social sharing
- [ ] AI crawlers configured
- [ ] FAQ items added (minimum 3 recommended)
- [ ] Google Rich Results Test shows no errors
- [ ] Robots.txt displays AI bot rules

---

## For Multiple Sites

### Export Settings from First Site

1. Configure plugin on your first site
2. Go to **SEO & AEO → Tools**
3. Click "Export Settings"
4. Save the JSON file (e.g., `seo-aeo-settings-site1.json`)

### Import to Other Sites

1. Install and activate plugin on new site
2. Go to **SEO & AEO → Tools**
3. Upload the exported JSON file
4. Click "Import Settings"
5. Adjust site-specific details (org name, URL, logo)
6. **Save Changes**

---

## Recommended Settings by Site Type

### E-commerce / WooCommerce Sites

**Enable:**
- ✅ Product Schema
- ✅ Breadcrumb Schema
- ✅ Organization Schema
- ✅ FAQ Schema (product-related questions)
- ✅ All AI Crawlers
- ✅ All Meta Tags

**FAQs to Add:**
- Shipping policies
- Return policies
- Payment methods
- Product care instructions
- Warranty information

### Blog / Content Sites

**Enable:**
- ✅ Article Schema
- ✅ Breadcrumb Schema
- ✅ Organization Schema
- ✅ FAQ Schema (topic-specific)
- ✅ All AI Crawlers
- ✅ All Meta Tags

**FAQs to Add:**
- About your blog/brand
- How to subscribe
- Guest posting policies
- Content topics
- Expertise/credentials

### Auction Sites

**Enable:**
- ✅ Product Schema
- ✅ Organization Schema
- ✅ Breadcrumb Schema
- ✅ FAQ Schema
- ✅ All AI Crawlers
- ✅ All Meta Tags

**FAQs to Add:**
- How to bid
- Registration process
- Payment methods
- Buyer's fees
- Shipping/pickup

### Service / Business Sites

**Enable:**
- ✅ Organization Schema
- ✅ FAQ Schema
- ✅ Article Schema (for blog)
- ✅ All AI Crawlers
- ✅ All Meta Tags

**FAQs to Add:**
- Services offered
- Pricing information
- Service area
- Contact methods
- Business hours

---

## Troubleshooting

### Plugin won't activate
**Solution:** Check PHP version (requires 7.4+) and WordPress version (requires 5.8+)

### Schema not appearing in source code
**Solutions:**
1. Clear all caches (browser, WordPress, server)
2. Verify plugin is enabled in General tab
3. Check specific schema types are enabled in Schema tab

### Validation errors in Google Rich Results Test
**Solutions:**
1. Ensure organization details are complete
2. Add organization logo
3. Check product prices are set (for Product schema)
4. Verify images are present on pages

### Settings not saving
**Solutions:**
1. Check file permissions on wp-content folder
2. Disable other SEO plugins temporarily
3. Check for JavaScript errors in browser console

### Import not working
**Solutions:**
1. Verify JSON file is valid
2. Check file was exported from this plugin
3. Ensure file size under 2MB

---

## Advanced Configuration

### Custom Post Types

To add schema support for custom post types:

```php
// Add to your theme's functions.php or custom plugin
add_filter('seo_aeo_product_post_types', function($types) {
    $types[] = 'lot';           // Auction lots
    $types[] = 'custom_product'; // Custom products
    return $types;
});
```

### Modify Schema Output

```php
// Customize product schema
add_filter('seo_aeo_product_schema', function($schema, $post) {
    // Add custom fields
    $schema['brand'] = get_post_meta($post->ID, 'product_brand', true);
    $schema['mpn'] = get_post_meta($post->ID, 'manufacturer_pn', true);
    return $schema;
}, 10, 2);
```

---

## Performance Optimization

### Enable Caching
1. Go to **SEO & AEO → Schema**
2. ✅ Enable "Cache Schema"
3. **Save Changes**

### Server Caching
If using Nginx or server-level caching, clear cache after:
- Changing settings
- Adding/removing FAQs
- Updating organization details

**Clear Nginx cache:**
```bash
rm -rf /www/server/fastcgi_cache/*
```

---

## Getting Help

### Support Resources
- **Documentation:** README.md in plugin folder
- **Email Support:** support@smoothbyteit.dev
- **Validation Tools:** Available in Tools tab

### Before Requesting Support
Please provide:
1. WordPress version
2. PHP version
3. Active theme name
4. List of active plugins
5. Error messages (if any)
6. URL to test page

---

## Next Steps After Installation

1. **Week 1:** Monitor Google Search Console for rich results
2. **Week 2:** Check AI crawler visits in server logs
3. **Month 1:** Review click-through rates from search
4. **Month 3:** Assess overall SEO improvements

**Test regularly using Tools → Validation Tools**

---

## Updates & Maintenance

### Plugin Updates
- Updates will appear in WordPress Admin → Plugins
- Always backup before updating
- Test updates on staging site first

### Settings Backup
- Export settings monthly (Tools tab)
- Store JSON files securely
- Document any custom configurations

---

**Ready to optimize your site for search engines and AI platforms!** 🚀
