# Default Plugin Settings

## ✅ All Site-Enhancing Features Enabled by Default

Your SEO & AEO Optimizer Pro plugin now comes with **all beneficial features enabled** out of the box for maximum SEO/AEO/GEO coverage.

---

## 📊 Default Settings Overview

### **✅ Enabled by Default** (Recommended)

#### **Basic Schema Types:**
- ✅ **Organization Schema** - Your business/brand identity
- ✅ **Product Schema** - E-commerce and auction items
- ✅ **Article Schema** - Blog posts and content pages
- ✅ **Breadcrumb Schema** - Navigation hierarchy
- ✅ **FAQ Schema** - Questions and answers

#### **Advanced Schema Types (NEW!):**
- ✅ **Event Schema** - Perfect for auction events, sales, webinars
- ✅ **Review/Rating Schema** - Star ratings in search results
- ✅ **Video Schema** - Video content and thumbnails
- ✅ **HowTo Schema** - Step-by-step guides (AEO optimized)
- ✅ **Speakable Schema** - Voice search optimization

#### **Meta Tags:**
- ✅ **Social Meta Tags** - General meta descriptions
- ✅ **Open Graph Tags** - Facebook, LinkedIn sharing
- ✅ **Twitter Cards** - Twitter sharing previews

#### **AI Crawlers (AEO):**
- ✅ **Robots.txt Optimization** - AI-friendly crawling
- ✅ **GPTBot** - ChatGPT can crawl your site
- ✅ **CCBot** - Common Crawl indexing
- ✅ **Anthropic AI** - Claude can access your content
- ✅ **PerplexityBot** - Perplexity AI indexing
- ✅ **YouBot** - You.com search inclusion

#### **Local SEO / GEO:**
- ✅ **LocalBusiness Schema** - Local search optimization
- 📝 Address fields (blank by default, fill in to activate)
- 📝 Coordinates (blank by default, fill in to activate)
- 📝 Opening hours (blank by default, fill in to activate)

#### **Technical SEO:**
- ✅ **Canonical URLs** - Prevent duplicate content
- ✅ **Image Optimization** - Lazy loading, async decoding
- ✅ **DNS Prefetch** - Faster external resource loading
- ✅ **Max Image Preview: Large** - Better image previews in search
- ✅ **Max Snippet: Unlimited** - Full text snippets
- ✅ **Max Video Preview: Unlimited** - Full video previews
- ✅ **NoIndex Search Results** - Prevents duplicate content issues

#### **Performance:**
- ✅ **Schema Caching** - Faster page loads

---

### **⚪ User Choice (Configure as Needed)**

These are disabled by default or require configuration:

#### **Archive Indexing:**
- ⚪ **NoIndex Archives** - Off by default (archives are indexed)
- ⚪ **NoIndex Paginated Pages** - Off by default (page 2, 3, etc. indexed)

#### **Debug Mode:**
- ⚪ **Debug Mode** - Off by default (enable only for troubleshooting)

---

## 🎯 Why These Defaults?

### **All Schema Types Enabled:**
**Why:** Schema types only output when relevant data exists. No harm enabling them all!

**Example:**
- Event schema? Only shows if `_event_date` custom field exists
- Review schema? Only shows if `_rating` field exists
- Video schema? Only shows if `_video_url` field exists

**Result:** Maximum SEO coverage with zero negative effects! ✅

### **All AI Crawlers Allowed:**
**Why:** You want AI platforms to know about your content!

**Benefits:**
- ChatGPT can cite your articles
- Claude can reference your guides
- Perplexity includes you in answers
- You.com shows your content

**No downside** - only increases visibility! ✅

### **Local SEO Enabled:**
**Why:** Even if you don't fill in address details, enabling it doesn't hurt.

**How it works:**
- Enabled by default
- Won't output schema until you add address/coordinates
- Fill in Local/GEO tab when ready

**Flexibility:** Works for local AND online-only businesses! ✅

### **Technical SEO All On:**
**Why:** These are pure optimizations with no downsides.

**Benefits:**
- Faster page loads (lazy loading, DNS prefetch)
- Better crawling (canonical URLs)
- Better search previews (max-image-preview: large)
- No duplicate content issues

**Performance impact:** Negligible, all positive! ✅

---

## 📝 What's Blank by Default (You Should Fill In)

### **Required for Full Functionality:**

**Organization Details (General Tab):**
- ⚠️ Organization Logo URL
- ⚠️ Organization Description (auto-filled from site tagline)
- ⚠️ Social Media Links (optional but recommended)

**Local/GEO Settings (Local/GEO Tab):**
Only if you're a local business:
- ⚠️ Street Address
- ⚠️ City, State, Postal Code, Country
- ⚠️ Phone Number
- ⚠️ Email
- ⚠️ Latitude/Longitude (for map accuracy)
- ⚠️ Opening Hours
- ⚠️ Service Areas

**FAQ Items (FAQ Schema Tab):**
- ⚠️ Add your frequently asked questions (optional)

---

## 🚀 First-Time Setup Checklist

### **Immediate (5 minutes):**
1. Go to **General** tab
   - ✅ Plugin enabled (default)
   - 📝 Add organization logo URL
   - 📝 Review organization description
   - 📝 Add social media links

2. Go to **Schema** tab
   - ✅ All basic schemas enabled (default)

3. Go to **Advanced** tab
   - ✅ All advanced schemas enabled (default)
   - ✅ All technical SEO enabled (default)

4. Go to **Meta Tags** tab
   - ✅ All meta tags enabled (default)

5. Go to **AI Crawlers** tab
   - ✅ All AI bots allowed (default)

### **If You're a Local Business (10 minutes):**
6. Go to **Local/GEO** tab
   - ✅ Local SEO enabled (default)
   - 📝 Select business type
   - 📝 Fill in complete address
   - 📝 Add phone and email
   - 📝 Add coordinates (find on Google Maps)
   - 📝 Add opening hours
   - 📝 Add service areas

### **Optional Enhancements:**
7. Go to **FAQ Schema** tab
   - 📝 Add 5-10 FAQs about your business/auctions

8. Go to **Tools** tab
   - ✅ Validate with Google Rich Results Test
   - 📝 Export settings for backup

---

## 🔍 Feature Status by Tab

### **General Tab:**
```
✅ Plugin Enabled: true
✅ Post Types: post, page, product (and 'lot' auto-detected)
📝 Organization Name: (auto-filled)
📝 Organization Logo: (blank - ADD THIS)
📝 Social Links: (blank - OPTIONAL)
```

### **Schema Tab:**
```
✅ Organization: true
✅ Product: true
✅ Article: true
✅ Breadcrumb: true
✅ FAQ: true
✅ Cache Schema: true
```

### **Local/GEO Tab:**
```
✅ Local SEO Enabled: true
📝 Business Type: LocalBusiness (change if needed)
📝 Address: (blank - fill if local business)
📝 Coordinates: (blank - add for map accuracy)
📝 Opening Hours: (blank - optional)
```

### **Advanced Tab:**
```
✅ Event Schema: true (NEW!)
✅ Review Schema: true (NEW!)
✅ Video Schema: true (NEW!)
✅ HowTo Schema: true (NEW!)
✅ Speakable Schema: true (NEW!)
✅ Canonical URLs: true
✅ Image Optimization: true
✅ DNS Prefetch: true
⚪ NoIndex Archives: false (your choice)
✅ NoIndex Search: true
⚪ NoIndex Paginated: false (your choice)
✅ Max Image Preview: large
✅ Max Snippet: unlimited
✅ Max Video Preview: unlimited
```

### **Meta Tags Tab:**
```
✅ Meta Tags: true
✅ Open Graph: true
✅ Twitter Cards: true
```

### **AI Crawlers Tab:**
```
✅ Robots.txt Optimization: true
✅ GPTBot: true
✅ CCBot: true
✅ Anthropic AI: true
✅ PerplexityBot: true
✅ YouBot: true
```

### **FAQ Schema Tab:**
```
✅ FAQ Enabled: true
📝 FAQ Items: (blank - add your FAQs)
```

---

## 💡 Smart Defaults Explained

### **"Won't All These Schemas Slow Down My Site?"**
**No!** Here's why:
- Schema caching is enabled (generated once, cached)
- Only relevant schemas output (event schema won't show on posts without event dates)
- JSON-LD is lightweight (~2-5KB per page)
- Modern browsers handle this instantly

**Performance impact:** <0.01 seconds ⚡

### **"What if I Don't Have Videos/Events/Reviews?"**
**No problem!** The schemas are smart:
- Event schema checks for `_event_date` field → Not found? Doesn't output
- Video schema checks for `_video_url` field → Not found? Doesn't output
- Review schema checks for `_rating` field → Not found? Doesn't output

**Result:** Only outputs when data exists! ✅

### **"Should I Disable Schemas I Don't Use?"**
**Not necessary!** But you can if you want:
- They don't hurt performance
- They're future-proof (when you add videos later, it's ready)
- Search engines ignore empty schemas gracefully

**Recommendation:** Leave them all enabled! ✅

---

## 🎓 Understanding the Defaults

### **Conservative vs Aggressive:**
These defaults are **intelligently aggressive** - they maximize SEO while being safe:

**Aggressive (Good!):**
- ✅ All schemas enabled (smart, data-dependent)
- ✅ All AI crawlers allowed (visibility boost)
- ✅ All technical SEO on (performance + SEO)
- ✅ Local SEO on (fill in later)

**Conservative (Safe!):**
- ⚪ Archives indexed (standard practice)
- ⚪ Pagination indexed (standard practice)
- ⚪ Debug off (production-ready)

**Result:** Best of both worlds! 🎯

---

## 🔄 If You Need to Reset

### **Reset to Defaults:**
1. Go to **WordPress Admin → Plugins**
2. Deactivate "SEO & AEO Optimizer Pro"
3. Reactivate it
4. All defaults restored ✅

### **Or via Database:**
```sql
DELETE FROM wp_options WHERE option_name = 'seo_aeo_options';
```
Then reload any admin page to regenerate defaults.

---

## ✅ Summary

**Total Features Enabled by Default:** 30+

**Breakdown:**
- ✅ 10 Schema types
- ✅ 3 Meta tag systems
- ✅ 5 AI crawler bots
- ✅ 1 Local SEO system
- ✅ 8 Technical SEO features
- ✅ 1 Performance optimization

**User Action Required:** Just fill in your:
- Organization logo
- Local address (if applicable)
- FAQs (optional)

**Time to Full Setup:** 10-15 minutes

**Result:** Enterprise-level SEO/AEO/GEO optimization out of the box! 🚀

---

**Version:** 2.0.0  
**Last Updated:** November 23, 2025  
**Default Philosophy:** Maximum coverage, zero harm, smart activation
