# Changelog

All notable changes to SEO & AEO Optimizer Pro will be documented in this file.

## [2.1.0] - 2024-11-23

### Added
- **Automatic Update System**: Built-in integration with WP Plugin Deployer
- **Update Settings Tab**: Configure deployment server and API keys
- **Health Monitoring**: Automatic status reporting to deployment server
- **Version Management**: Support for multiple versions with auto-detection
- **Connection Testing**: Test deployment server connectivity
- **Manual Update Checks**: Force immediate update checks from admin
- **Auto-Install Option**: Choose between automatic or manual updates
- **Admin Notifications**: Alerts when update server is not configured
- **AJAX Handlers**: Test connection, check updates, save settings

### Changed
- Enhanced plugin architecture to support remote updates
- Improved settings UI with new Updates tab
- Better error handling and user feedback

### Technical
- Added `class-auto-updater.php` for update management
- Added `admin/tabs/updates.php` for settings interface
- WordPress Plugin API integration for seamless updates
- Cron jobs for hourly update checks and bi-daily health reports
- API key authentication for secure communication

## [2.0.0] - 2024-11-20

### Added
- Initial release with comprehensive SEO & AEO features
- Schema.org markup generation
- AI crawler support (GPTBot, Claude, Perplexity, etc.)
- Advanced meta tags (Open Graph, Twitter Cards)
- Local SEO / GEO features
- FAQ Schema support
- Technical SEO optimizations
- Robots.txt optimization
- Image optimization
- DNS prefetch and resource hints

### Features
- Organization Schema
- Product Schema
- Breadcrumb Schema
- Article Schema
- Event Schema
- Review Schema
- Video Schema
- HowTo Schema
- Speakable Schema
- Advanced Schema customization
- Auction compatibility

---

## Version Numbering

This project follows [Semantic Versioning](https://semver.org/):
- **MAJOR** version for incompatible API changes
- **MINOR** version for new functionality in a backward compatible manner
- **PATCH** version for backward compatible bug fixes
