# Release Notes - Version 2.6.0

**Release Date:** November 23, 2024  
**Type:** Major Feature Update

## 🎯 What's New

### Dynamic XML Sitemap Generator
Complete automatic sitemap generation system built directly into the plugin - no third-party plugins needed!

#### ✅ Core Features
- **Automatic Sitemap Generation**: Creates XML sitemaps for all public post types
- **Sitemap Index**: Main sitemap at `/sitemap.xml` with links to all sub-sitemaps
- **Individual Sitemaps**: Separate sitemaps per post type (`/sitemap-post.xml`, `/sitemap-page.xml`, etc.)
- **Smart Caching**: 24-hour cache with automatic refresh on content changes
- **Image Support**: Includes featured images in sitemap using image sitemap extension
- **SEO Optimized**: Proper priority and changefreq settings per content type
- **Robots.txt Integration**: Automatically adds sitemap reference to robots.txt

#### ⚙️ Admin Features
- **New "XML Sitemap" Tab**: Dedicated settings page in plugin admin
- **Enable/Disable Control**: Toggle sitemap generation on/off
- **Post Type Selection**: Choose which post types to include
- **One-Click Preview**: View all sitemap URLs with direct links
- **Clear Cache Button**: Force refresh sitemaps instantly
- **Ping Search Engines**: Notify Google & Bing about sitemap updates

#### 🚀 Performance & Automation
- **Efficient Caching**: Transient-based caching system (24 hours)
- **Auto Cache Flush**: Automatically clears cache when posts are saved/deleted
- **Lazy Loading**: Sitemaps generated on-demand, not on every page load
- **Database Optimized**: Minimal queries with proper indexing
- **No External Dependencies**: Pure PHP implementation

#### 📊 SEO Standards
- **Google XML Sitemap Format**: Fully compliant with sitemap protocol
- **Image Sitemap Extension**: Includes featured images for better image SEO
- **Proper Timestamps**: Uses `lastmod` with ISO 8601 format
- **Change Frequency**: Optimized per post type (daily for auctions, weekly for posts, monthly for pages)
- **Priority Values**: SEO-optimized priority levels per content type

### Settings Improvements
- **Default Enabled**: Sitemap generation enabled by default on fresh installs
- **Posts & Pages Included**: Default post types pre-selected
- **User-Friendly UI**: Clear descriptions and helpful tooltips
- **AJAX Actions**: Cache clearing and search engine ping via AJAX

## 🔧 Technical Details

### New Files
- `includes/class-sitemap-generator.php` - Core sitemap generation class
- `admin/tabs/sitemap.php` - Admin settings tab

### Modified Files
- `seo-aeo-optimizer.php` - Added sitemap initialization and AJAX handlers
- `admin/class-admin-settings.php` - Added sitemap tab to navigation

### New Endpoints
- `/sitemap.xml` - Main sitemap index
- `/sitemap-{post-type}.xml` - Individual post type sitemaps

### Database
- Uses WordPress transients for caching (no new tables)

## 📋 Default Settings

```php
'sitemap_enabled' => true,
'sitemap_post_types' => array('post', 'page'),
```

## 🎨 Change Frequency by Post Type

- **Pages**: Monthly
- **Posts**: Weekly
- **Auctions**: Daily
- **Others**: Weekly (default)

## 🔗 Priority by Post Type

- **Pages**: 0.8
- **Auctions**: 0.7
- **Posts**: 0.6
- **Others**: 0.5 (default)

## 🔒 Compatibility

- **WordPress**: 5.8+
- **PHP**: 7.4+
- **Custom Post Types**: Fully supported
- **Multisite**: Compatible
- **Caching Plugins**: Compatible

## 📈 Benefits

1. **No Additional Plugins**: Built-in sitemap functionality
2. **SEO Optimized**: Proper structure and metadata
3. **Automatic Updates**: No manual sitemap management
4. **Fast & Efficient**: Smart caching prevents performance impact
5. **Search Engine Friendly**: Easy discovery and indexing

## 🚀 Upgrade Instructions

1. **Backup Your Site**: Always recommended before updates
2. **Update Plugin**: Replace plugin files with v2.6.0
3. **Activate**: Sitemaps are enabled by default
4. **Configure** (Optional): Go to SEO & AEO → XML Sitemap to customize
5. **Verify**: Visit `/sitemap.xml` to see your sitemap

## ⚠️ Important Notes

- Sitemap generation is **enabled by default** on new installs
- Existing installations will need to enable it in settings
- Rewrite rules are automatically flushed on activation
- Cache is automatically cleared when content is updated
- Compatible with existing WordPress native sitemaps

## 🐛 Bug Fixes

- Fixed checkbox default states for all settings tabs
- Improved option sanitization for array values
- Enhanced transient cleanup on cache flush

## 💡 Pro Tips

1. **After Major Content Changes**: Use "Clear Sitemap Cache" button
2. **After Publishing Many Posts**: Click "Ping Search Engines"
3. **Custom Post Types**: Enable them in sitemap settings
4. **Performance**: Default 24-hour cache is optimal for most sites

---

**Previous Version:** 2.5.3 (Default enabled plugin feature)  
**Next Version:** TBD

**Need Help?** Visit plugin settings or contact SmoothByte IT support.
